package io.dingodb.sdk.service.entity.raft;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import io.dingodb.sdk.grpc.serializer.Reader;
import io.dingodb.sdk.grpc.serializer.SizeUtils;
import io.dingodb.sdk.grpc.serializer.Writer;
import io.dingodb.sdk.service.entity.Message;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.FieldNameConstants;
import lombok.experimental.SuperBuilder;

@Data
@SuperBuilder
@NoArgsConstructor
@FieldNameConstants
public class LogEntry implements Message {
    private byte[] data;

    private long term;

    private long index;

    private Object ext$;

    @Override
    public void write(CodedOutputStream out) {
        Writer.write(1, index, out);
        Writer.write(2, term, out);
        Writer.write(3, data, out);
    }

    @Override
    public boolean read(CodedInputStream input) {
        int number = 0;
        boolean hasValue = false;
        while((number = Reader.readNumber(input)) != 0) {
            switch(number) {
                case 1: index = Reader.readLong(input); hasValue = true; break;
                case 2: term = Reader.readLong(input); hasValue = true; break;
                case 3: data = Reader.readBytes(input); hasValue = true; break;
                default: Reader.skip(input);
            }
        }
        return hasValue;
    }

    @Override
    public int sizeOf() {
        int size = 0;
        size += SizeUtils.sizeOf(1, index);
        size += SizeUtils.sizeOf(2, term);
        size += SizeUtils.sizeOf(3, data);
        return size;
    }
}
