package io.dingodb.sdk.service.entity.node;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import io.dingodb.sdk.grpc.serializer.Reader;
import io.dingodb.sdk.grpc.serializer.SizeUtils;
import io.dingodb.sdk.grpc.serializer.Writer;
import io.dingodb.sdk.service.entity.Message;
import io.dingodb.sdk.service.entity.common.Range;
import io.dingodb.sdk.service.entity.common.RegionEpoch;
import java.util.List;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.FieldNameConstants;
import lombok.experimental.SuperBuilder;

@Data
@SuperBuilder
@NoArgsConstructor
@FieldNameConstants
public class VectorIndexSnapshotMeta implements Message {
    private RegionEpoch epoch;

    private long snapshotLogIndex;

    private Range range;

    private List<String> filenames;

    private long vectorIndexId;

    private Object ext$;

    @Override
    public void write(CodedOutputStream out) {
        Writer.write(1, vectorIndexId, out);
        Writer.write(2, snapshotLogIndex, out);
        Writer.write(3, filenames, (n, v) -> Writer.write(n, v, out));
        Writer.write(4, epoch, out);
        Writer.write(5, range, out);
    }

    @Override
    public boolean read(CodedInputStream input) {
        int number = 0;
        boolean hasValue = false;
        while((number = Reader.readNumber(input)) != 0) {
            switch(number) {
                case 1: vectorIndexId = Reader.readLong(input); hasValue = true; break;
                case 2: snapshotLogIndex = Reader.readLong(input); hasValue = true; break;
                case 3: filenames = Reader.readList(filenames, input, Reader::readString); hasValue = true; break;
                case 4: epoch = Reader.readMessage(new RegionEpoch(), input); hasValue = hasValue ? hasValue : epoch != null; break;
                case 5: range = Reader.readMessage(new Range(), input); hasValue = hasValue ? hasValue : range != null; break;
                default: Reader.skip(input);
            }
        }
        return hasValue;
    }

    @Override
    public int sizeOf() {
        int size = 0;
        size += SizeUtils.sizeOf(1, vectorIndexId);
        size += SizeUtils.sizeOf(2, snapshotLogIndex);
        size += SizeUtils.sizeOf(3, filenames, SizeUtils::sizeOf);
        size += SizeUtils.sizeOf(4, epoch);
        size += SizeUtils.sizeOf(5, range);
        return size;
    }
}
