package io.dingodb.sdk.service.entity.node;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import io.dingodb.sdk.grpc.serializer.Reader;
import io.dingodb.sdk.grpc.serializer.SizeUtils;
import io.dingodb.sdk.grpc.serializer.Writer;
import io.dingodb.sdk.service.entity.Message;
import io.dingodb.sdk.service.entity.common.ClusterRole;
import io.dingodb.sdk.service.entity.common.Location;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.FieldNameConstants;
import lombok.experimental.SuperBuilder;

@Data
@SuperBuilder
@NoArgsConstructor
@FieldNameConstants
public class NodeInfo implements Message {
    private Location serverLocation;

    private long id;

    private Location raftLocation;

    private ClusterRole role;

    private Object ext$;

    @Override
    public void write(CodedOutputStream out) {
        Writer.write(1, id, out);
        Writer.write(2, role, out);
        Writer.write(3, serverLocation, out);
        Writer.write(4, raftLocation, out);
    }

    @Override
    public boolean read(CodedInputStream input) {
        int number = 0;
        boolean hasValue = false;
        while((number = Reader.readNumber(input)) != 0) {
            switch(number) {
                case 1: id = Reader.readLong(input); hasValue = true; break;
                case 2: role = ClusterRole.forNumber(Reader.readInt(input));hasValue = true; break;
                case 3: serverLocation = Reader.readMessage(new Location(), input); hasValue = hasValue ? hasValue : serverLocation != null; break;
                case 4: raftLocation = Reader.readMessage(new Location(), input); hasValue = hasValue ? hasValue : raftLocation != null; break;
                default: Reader.skip(input);
            }
        }
        return hasValue;
    }

    @Override
    public int sizeOf() {
        int size = 0;
        size += SizeUtils.sizeOf(1, id);
        size += SizeUtils.sizeOf(2, role);
        size += SizeUtils.sizeOf(3, serverLocation);
        size += SizeUtils.sizeOf(4, raftLocation);
        return size;
    }
}
