package io.dingodb.sdk.service.entity.node;

import io.dingodb.sdk.service.entity.Numeric;

public enum LogLevel implements Numeric {
    UNRECOGNIZED(-1),

    DEBUG(0),

    INFO(1),

    WARNING(2),

    ERROR(3),

    FATAL(4);

    public final Integer number;

    private Object ext$;

    private LogLevel(Integer number) {
        this.number = number;
    }

    @Override
    public int number() {
        return number;
    }

    public static LogLevel forNumber(int number) {
        switch(number) {
            case -1: return UNRECOGNIZED;
            case 0: return DEBUG;
            case 1: return INFO;
            case 2: return WARNING;
            case 3: return ERROR;
            case 4: return FATAL;
            default: return null;
        }
    }
}
