package io.dingodb.sdk.service.entity.node;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import io.dingodb.sdk.grpc.serializer.Reader;
import io.dingodb.sdk.grpc.serializer.SizeUtils;
import io.dingodb.sdk.grpc.serializer.Writer;
import io.dingodb.sdk.service.entity.Message;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.FieldNameConstants;
import lombok.experimental.SuperBuilder;

@Data
@SuperBuilder
@NoArgsConstructor
@FieldNameConstants
public class LogDetail implements Message {
    private boolean stopLoggingIfFullDisk;

    private int verbose;

    private int maxLogSize;

    private int logBufSecs;

    private Object ext$;

    @Override
    public void write(CodedOutputStream out) {
        Writer.write(1, logBufSecs, out);
        Writer.write(2, maxLogSize, out);
        Writer.write(3, stopLoggingIfFullDisk, out);
        Writer.write(4, verbose, out);
    }

    @Override
    public boolean read(CodedInputStream input) {
        int number = 0;
        boolean hasValue = false;
        while((number = Reader.readNumber(input)) != 0) {
            switch(number) {
                case 1: logBufSecs = Reader.readInt(input); hasValue = true; break;
                case 2: maxLogSize = Reader.readInt(input); hasValue = true; break;
                case 3: stopLoggingIfFullDisk = Reader.readBoolean(input); hasValue = true; break;
                case 4: verbose = Reader.readInt(input); hasValue = true; break;
                default: Reader.skip(input);
            }
        }
        return hasValue;
    }

    @Override
    public int sizeOf() {
        int size = 0;
        size += SizeUtils.sizeOf(1, logBufSecs);
        size += SizeUtils.sizeOf(2, maxLogSize);
        size += SizeUtils.sizeOf(3, stopLoggingIfFullDisk);
        size += SizeUtils.sizeOf(4, verbose);
        return size;
    }
}
