package io.dingodb.sdk.service.entity.node;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import io.dingodb.sdk.grpc.serializer.Reader;
import io.dingodb.sdk.grpc.serializer.SizeUtils;
import io.dingodb.sdk.grpc.serializer.Writer;
import io.dingodb.sdk.service.entity.Message;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.FieldNameConstants;
import lombok.experimental.SuperBuilder;

@Data
@SuperBuilder
@NoArgsConstructor
@FieldNameConstants
public class FailPointAction implements Message {
    private int maxCount;

    private int percent;

    private int runCount;

    private String arg;

    private String type;

    private Object ext$;

    @Override
    public void write(CodedOutputStream out) {
        Writer.write(1, type, out);
        Writer.write(2, percent, out);
        Writer.write(3, maxCount, out);
        Writer.write(4, runCount, out);
        Writer.write(5, arg, out);
    }

    @Override
    public boolean read(CodedInputStream input) {
        int number = 0;
        boolean hasValue = false;
        while((number = Reader.readNumber(input)) != 0) {
            switch(number) {
                case 1: type = Reader.readString(input); hasValue = true; break;
                case 2: percent = Reader.readInt(input); hasValue = true; break;
                case 3: maxCount = Reader.readInt(input); hasValue = true; break;
                case 4: runCount = Reader.readInt(input); hasValue = true; break;
                case 5: arg = Reader.readString(input); hasValue = true; break;
                default: Reader.skip(input);
            }
        }
        return hasValue;
    }

    @Override
    public int sizeOf() {
        int size = 0;
        size += SizeUtils.sizeOf(1, type);
        size += SizeUtils.sizeOf(2, percent);
        size += SizeUtils.sizeOf(3, maxCount);
        size += SizeUtils.sizeOf(4, runCount);
        size += SizeUtils.sizeOf(5, arg);
        return size;
    }
}
