package io.dingodb.sdk.service.entity.node;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import io.dingodb.sdk.grpc.serializer.Reader;
import io.dingodb.sdk.grpc.serializer.SizeUtils;
import io.dingodb.sdk.grpc.serializer.Writer;
import io.dingodb.sdk.service.entity.Message;
import java.util.List;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.FieldNameConstants;
import lombok.experimental.SuperBuilder;

@Data
@SuperBuilder
@NoArgsConstructor
@FieldNameConstants
public class FailPoint implements Message {
    private String name;

    private List<FailPointAction> actions;

    private String config;

    private Object ext$;

    @Override
    public void write(CodedOutputStream out) {
        Writer.write(1, name, out);
        Writer.write(2, config, out);
        Writer.write(10, actions, (n, v) -> Writer.write(n, v, out));
    }

    @Override
    public boolean read(CodedInputStream input) {
        int number = 0;
        boolean hasValue = false;
        while((number = Reader.readNumber(input)) != 0) {
            switch(number) {
                case 1: name = Reader.readString(input); hasValue = true; break;
                case 2: config = Reader.readString(input); hasValue = true; break;
                case 10: actions = Reader.readList(actions, input, in -> Reader.readMessage(new FailPointAction(), in)); hasValue = true; break;
                default: Reader.skip(input);
            }
        }
        return hasValue;
    }

    @Override
    public int sizeOf() {
        int size = 0;
        size += SizeUtils.sizeOf(1, name);
        size += SizeUtils.sizeOf(2, config);
        size += SizeUtils.sizeOf(10, actions, SizeUtils::sizeOf);
        return size;
    }
}
