package io.dingodb.sdk.service.entity.node;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import io.dingodb.sdk.grpc.serializer.Reader;
import io.dingodb.sdk.grpc.serializer.SizeUtils;
import io.dingodb.sdk.grpc.serializer.Writer;
import io.dingodb.sdk.service.entity.Message;
import io.dingodb.sdk.service.entity.common.Range;
import io.dingodb.sdk.service.entity.common.RegionEpoch;
import io.dingodb.sdk.service.entity.common.RequestInfo;
import io.dingodb.sdk.service.entity.raft.LogEntry;
import java.util.List;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.FieldNameConstants;
import lombok.experimental.SuperBuilder;

@Data
@SuperBuilder
@NoArgsConstructor
@FieldNameConstants
public class CommitMergeRequest implements Message, Message.Request {
    private long jobId;

    private long prepareMergeLogId;

    private long sourceRegionId;

    private RegionEpoch sourceRegionEpoch;

    private RegionEpoch targetRegionEpoch;

    private long targetRegionId;

    private RequestInfo requestInfo;

    private Range sourceRegionRange;

    private Range targetRegionRange;

    private List<LogEntry> entries;

    private Object ext$;

    @Override
    public void write(CodedOutputStream out) {
        Writer.write(1, requestInfo, out);
        Writer.write(2, jobId, out);
        Writer.write(3, sourceRegionId, out);
        Writer.write(4, sourceRegionEpoch, out);
        Writer.write(5, sourceRegionRange, out);
        Writer.write(6, targetRegionId, out);
        Writer.write(7, targetRegionEpoch, out);
        Writer.write(8, targetRegionRange, out);
        Writer.write(9, prepareMergeLogId, out);
        Writer.write(10, entries, (n, v) -> Writer.write(n, v, out));
    }

    @Override
    public boolean read(CodedInputStream input) {
        int number = 0;
        boolean hasValue = false;
        while((number = Reader.readNumber(input)) != 0) {
            switch(number) {
                case 1: requestInfo = Reader.readMessage(new RequestInfo(), input); hasValue = hasValue ? hasValue : requestInfo != null; break;
                case 2: jobId = Reader.readLong(input); hasValue = true; break;
                case 3: sourceRegionId = Reader.readLong(input); hasValue = true; break;
                case 4: sourceRegionEpoch = Reader.readMessage(new RegionEpoch(), input); hasValue = hasValue ? hasValue : sourceRegionEpoch != null; break;
                case 5: sourceRegionRange = Reader.readMessage(new Range(), input); hasValue = hasValue ? hasValue : sourceRegionRange != null; break;
                case 6: targetRegionId = Reader.readLong(input); hasValue = true; break;
                case 7: targetRegionEpoch = Reader.readMessage(new RegionEpoch(), input); hasValue = hasValue ? hasValue : targetRegionEpoch != null; break;
                case 8: targetRegionRange = Reader.readMessage(new Range(), input); hasValue = hasValue ? hasValue : targetRegionRange != null; break;
                case 9: prepareMergeLogId = Reader.readLong(input); hasValue = true; break;
                case 10: entries = Reader.readList(entries, input, in -> Reader.readMessage(new LogEntry(), in)); hasValue = true; break;
                default: Reader.skip(input);
            }
        }
        return hasValue;
    }

    @Override
    public int sizeOf() {
        int size = 0;
        size += SizeUtils.sizeOf(1, requestInfo);
        size += SizeUtils.sizeOf(2, jobId);
        size += SizeUtils.sizeOf(3, sourceRegionId);
        size += SizeUtils.sizeOf(4, sourceRegionEpoch);
        size += SizeUtils.sizeOf(5, sourceRegionRange);
        size += SizeUtils.sizeOf(6, targetRegionId);
        size += SizeUtils.sizeOf(7, targetRegionEpoch);
        size += SizeUtils.sizeOf(8, targetRegionRange);
        size += SizeUtils.sizeOf(9, prepareMergeLogId);
        size += SizeUtils.sizeOf(10, entries, SizeUtils::sizeOf);
        return size;
    }
}
