package io.dingodb.sdk.service.entity.meta;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import io.dingodb.sdk.grpc.serializer.Reader;
import io.dingodb.sdk.grpc.serializer.SizeUtils;
import io.dingodb.sdk.grpc.serializer.Writer;
import io.dingodb.sdk.service.entity.Message;
import java.util.List;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.FieldNameConstants;
import lombok.experimental.SuperBuilder;

@Data
@SuperBuilder
@NoArgsConstructor
@FieldNameConstants
public class WatchNode implements Message {
    private long isWatching;

    private long watchedRevision;

    private List<MetaEventType> eventTypes;

    private long startRevision;

    private long watchId;

    private long lastSendTimestampMs;

    private List<MetaEvent> pendingEvents;

    private Object ext$;

    @Override
    public void write(CodedOutputStream out) {
        Writer.write(3, watchId, out);
        Writer.write(4, startRevision, out);
        Writer.write(5, watchedRevision, out);
        Writer.write(6, isWatching, out);
        Writer.write(7, eventTypes, (n, v) -> Writer.write(n, v, out));
        Writer.write(8, pendingEvents, (n, v) -> Writer.write(n, v, out));
        Writer.write(9, lastSendTimestampMs, out);
    }

    @Override
    public boolean read(CodedInputStream input) {
        int number = 0;
        boolean hasValue = false;
        while((number = Reader.readNumber(input)) != 0) {
            switch(number) {
                case 3: watchId = Reader.readLong(input); hasValue = true; break;
                case 4: startRevision = Reader.readLong(input); hasValue = true; break;
                case 5: watchedRevision = Reader.readLong(input); hasValue = true; break;
                case 6: isWatching = Reader.readLong(input); hasValue = true; break;
                case 7: eventTypes = Reader.readList(eventTypes, input, in -> MetaEventType.forNumber(Reader.readInt(input))); hasValue = true; break;
                case 8: pendingEvents = Reader.readList(pendingEvents, input, in -> Reader.readMessage(new MetaEvent(), in)); hasValue = true; break;
                case 9: lastSendTimestampMs = Reader.readLong(input); hasValue = true; break;
                default: Reader.skip(input);
            }
        }
        return hasValue;
    }

    @Override
    public int sizeOf() {
        int size = 0;
        size += SizeUtils.sizeOf(3, watchId);
        size += SizeUtils.sizeOf(4, startRevision);
        size += SizeUtils.sizeOf(5, watchedRevision);
        size += SizeUtils.sizeOf(6, isWatching);
        size += SizeUtils.sizeOf(7, eventTypes, SizeUtils::sizeOf);
        size += SizeUtils.sizeOf(8, pendingEvents, SizeUtils::sizeOf);
        size += SizeUtils.sizeOf(9, lastSendTimestampMs);
        return size;
    }
}
