package io.dingodb.sdk.service.entity.meta;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import io.dingodb.sdk.grpc.serializer.Reader;
import io.dingodb.sdk.grpc.serializer.SizeUtils;
import io.dingodb.sdk.grpc.serializer.Writer;
import io.dingodb.sdk.service.entity.Message;
import io.dingodb.sdk.service.entity.common.ResponseInfo;
import io.dingodb.sdk.service.entity.error.Error;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.FieldNameConstants;
import lombok.experimental.SuperBuilder;

@Data
@SuperBuilder
@NoArgsConstructor
@FieldNameConstants
public class TsoResponse implements Message, Message.Response {
    private Error error;

    private ResponseInfo responseInfo;

    private long savePhysical;

    private long systemTime;

    private TsoTimestamp startTimestamp;

    private TsoOpType opType;

    private long count;

    private String leader;

    private Object ext$;

    @Override
    public void write(CodedOutputStream out) {
        Writer.write(1, responseInfo, out);
        Writer.write(2, error, out);
        Writer.write(3, opType, out);
        Writer.write(4, startTimestamp, out);
        Writer.write(5, count, out);
        Writer.write(6, savePhysical, out);
        Writer.write(7, systemTime, out);
        Writer.write(8, leader, out);
    }

    @Override
    public boolean read(CodedInputStream input) {
        int number = 0;
        boolean hasValue = false;
        while((number = Reader.readNumber(input)) != 0) {
            switch(number) {
                case 1: responseInfo = Reader.readMessage(new ResponseInfo(), input); hasValue = hasValue ? hasValue : responseInfo != null; break;
                case 2: error = Reader.readMessage(new Error(), input); hasValue = hasValue ? hasValue : error != null; break;
                case 3: opType = TsoOpType.forNumber(Reader.readInt(input));hasValue = true; break;
                case 4: startTimestamp = Reader.readMessage(new TsoTimestamp(), input); hasValue = hasValue ? hasValue : startTimestamp != null; break;
                case 5: count = Reader.readLong(input); hasValue = true; break;
                case 6: savePhysical = Reader.readLong(input); hasValue = true; break;
                case 7: systemTime = Reader.readLong(input); hasValue = true; break;
                case 8: leader = Reader.readString(input); hasValue = true; break;
                default: Reader.skip(input);
            }
        }
        return hasValue;
    }

    @Override
    public int sizeOf() {
        int size = 0;
        size += SizeUtils.sizeOf(1, responseInfo);
        size += SizeUtils.sizeOf(2, error);
        size += SizeUtils.sizeOf(3, opType);
        size += SizeUtils.sizeOf(4, startTimestamp);
        size += SizeUtils.sizeOf(5, count);
        size += SizeUtils.sizeOf(6, savePhysical);
        size += SizeUtils.sizeOf(7, systemTime);
        size += SizeUtils.sizeOf(8, leader);
        return size;
    }
}
