package io.dingodb.sdk.service.entity.meta;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import io.dingodb.sdk.grpc.serializer.Reader;
import io.dingodb.sdk.grpc.serializer.SizeUtils;
import io.dingodb.sdk.grpc.serializer.Writer;
import io.dingodb.sdk.service.entity.Message;
import io.dingodb.sdk.service.entity.common.RequestInfo;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.FieldNameConstants;
import lombok.experimental.SuperBuilder;

@Data
@SuperBuilder
@NoArgsConstructor
@FieldNameConstants
public class TsoRequest implements Message, Message.Request {
    private boolean force;

    private long savePhysical;

    private TsoTimestamp currentTimestamp;

    private TsoOpType opType;

    private RequestInfo requestInfo;

    private long count;

    private Object ext$;

    @Override
    public void write(CodedOutputStream out) {
        Writer.write(1, requestInfo, out);
        Writer.write(2, opType, out);
        Writer.write(3, count, out);
        Writer.write(4, currentTimestamp, out);
        Writer.write(5, savePhysical, out);
        Writer.write(6, force, out);
    }

    @Override
    public boolean read(CodedInputStream input) {
        int number = 0;
        boolean hasValue = false;
        while((number = Reader.readNumber(input)) != 0) {
            switch(number) {
                case 1: requestInfo = Reader.readMessage(new RequestInfo(), input); hasValue = hasValue ? hasValue : requestInfo != null; break;
                case 2: opType = TsoOpType.forNumber(Reader.readInt(input));hasValue = true; break;
                case 3: count = Reader.readLong(input); hasValue = true; break;
                case 4: currentTimestamp = Reader.readMessage(new TsoTimestamp(), input); hasValue = hasValue ? hasValue : currentTimestamp != null; break;
                case 5: savePhysical = Reader.readLong(input); hasValue = true; break;
                case 6: force = Reader.readBoolean(input); hasValue = true; break;
                default: Reader.skip(input);
            }
        }
        return hasValue;
    }

    @Override
    public int sizeOf() {
        int size = 0;
        size += SizeUtils.sizeOf(1, requestInfo);
        size += SizeUtils.sizeOf(2, opType);
        size += SizeUtils.sizeOf(3, count);
        size += SizeUtils.sizeOf(4, currentTimestamp);
        size += SizeUtils.sizeOf(5, savePhysical);
        size += SizeUtils.sizeOf(6, force);
        return size;
    }
}
