package io.dingodb.sdk.service.entity.meta;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import io.dingodb.sdk.grpc.serializer.Reader;
import io.dingodb.sdk.grpc.serializer.SizeUtils;
import io.dingodb.sdk.grpc.serializer.Writer;
import io.dingodb.sdk.service.entity.Message;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.FieldNameConstants;
import lombok.experimental.SuperBuilder;

@Data
@SuperBuilder
@NoArgsConstructor
@FieldNameConstants
public class Tenant implements Message {
    private long createTimestamp;

    private String name;

    private long deleteTimestamp;

    private long id;

    private long revision;

    private long safePointTs;

    private long updateTimestamp;

    private long resolveLockSafePointTs;

    private String comment;

    private Object ext$;

    @Override
    public void write(CodedOutputStream out) {
        Writer.write(1, id, out);
        Writer.write(2, name, out);
        Writer.write(3, comment, out);
        Writer.write(10, createTimestamp, out);
        Writer.write(11, updateTimestamp, out);
        Writer.write(12, deleteTimestamp, out);
        Writer.write(20, safePointTs, out);
        Writer.write(21, revision, out);
        Writer.write(22, resolveLockSafePointTs, out);
    }

    @Override
    public boolean read(CodedInputStream input) {
        int number = 0;
        boolean hasValue = false;
        while((number = Reader.readNumber(input)) != 0) {
            switch(number) {
                case 1: id = Reader.readLong(input); hasValue = true; break;
                case 2: name = Reader.readString(input); hasValue = true; break;
                case 3: comment = Reader.readString(input); hasValue = true; break;
                case 10: createTimestamp = Reader.readLong(input); hasValue = true; break;
                case 11: updateTimestamp = Reader.readLong(input); hasValue = true; break;
                case 12: deleteTimestamp = Reader.readLong(input); hasValue = true; break;
                case 20: safePointTs = Reader.readLong(input); hasValue = true; break;
                case 21: revision = Reader.readLong(input); hasValue = true; break;
                case 22: resolveLockSafePointTs = Reader.readLong(input); hasValue = true; break;
                default: Reader.skip(input);
            }
        }
        return hasValue;
    }

    @Override
    public int sizeOf() {
        int size = 0;
        size += SizeUtils.sizeOf(1, id);
        size += SizeUtils.sizeOf(2, name);
        size += SizeUtils.sizeOf(3, comment);
        size += SizeUtils.sizeOf(10, createTimestamp);
        size += SizeUtils.sizeOf(11, updateTimestamp);
        size += SizeUtils.sizeOf(12, deleteTimestamp);
        size += SizeUtils.sizeOf(20, safePointTs);
        size += SizeUtils.sizeOf(21, revision);
        size += SizeUtils.sizeOf(22, resolveLockSafePointTs);
        return size;
    }
}
