package io.dingodb.sdk.service.entity.meta;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import io.dingodb.sdk.grpc.serializer.Reader;
import io.dingodb.sdk.grpc.serializer.SizeUtils;
import io.dingodb.sdk.grpc.serializer.Writer;
import io.dingodb.sdk.service.entity.Message;
import java.util.List;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.FieldNameConstants;
import lombok.experimental.SuperBuilder;

@Data
@SuperBuilder
@NoArgsConstructor
@FieldNameConstants
public class TablesAndIndexes implements Message {
    private List<TableDefinitionWithId> tables;

    private List<IndexDefinitionWithId> indexes;

    private Object ext$;

    @Override
    public void write(CodedOutputStream out) {
        Writer.write(1, tables, (n, v) -> Writer.write(n, v, out));
        Writer.write(2, indexes, (n, v) -> Writer.write(n, v, out));
    }

    @Override
    public boolean read(CodedInputStream input) {
        int number = 0;
        boolean hasValue = false;
        while((number = Reader.readNumber(input)) != 0) {
            switch(number) {
                case 1: tables = Reader.readList(tables, input, in -> Reader.readMessage(new TableDefinitionWithId(), in)); hasValue = true; break;
                case 2: indexes = Reader.readList(indexes, input, in -> Reader.readMessage(new IndexDefinitionWithId(), in)); hasValue = true; break;
                default: Reader.skip(input);
            }
        }
        return hasValue;
    }

    @Override
    public int sizeOf() {
        int size = 0;
        size += SizeUtils.sizeOf(1, tables, SizeUtils::sizeOf);
        size += SizeUtils.sizeOf(2, indexes, SizeUtils::sizeOf);
        return size;
    }
}
