package io.dingodb.sdk.service.entity.meta;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import io.dingodb.sdk.grpc.serializer.Reader;
import io.dingodb.sdk.grpc.serializer.SizeUtils;
import io.dingodb.sdk.grpc.serializer.Writer;
import io.dingodb.sdk.service.entity.Message;
import java.util.List;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.FieldNameConstants;
import lombok.experimental.SuperBuilder;

@Data
@SuperBuilder
@NoArgsConstructor
@FieldNameConstants
public class TableWithPartCount implements Message {
    private List<Integer> indexPartCount;

    private int tablePartCount;

    private int indexCount;

    private boolean hasTable;

    private Object ext$;

    @Override
    public void write(CodedOutputStream out) {
        Writer.write(1, hasTable, out);
        Writer.write(2, tablePartCount, out);
        Writer.write(3, indexCount, out);
        Writer.write(4, indexPartCount, out, Writer::write, SizeUtils::sizeOf);
    }

    @Override
    public boolean read(CodedInputStream input) {
        int number = 0;
        boolean hasValue = false;
        while((number = Reader.readNumber(input)) != 0) {
            switch(number) {
                case 1: hasTable = Reader.readBoolean(input); hasValue = true; break;
                case 2: tablePartCount = Reader.readInt(input); hasValue = true; break;
                case 3: indexCount = Reader.readInt(input); hasValue = true; break;
                case 4: indexPartCount = Reader.readPack(input, Reader::readInt); hasValue = true; break;
                default: Reader.skip(input);
            }
        }
        return hasValue;
    }

    @Override
    public int sizeOf() {
        int size = 0;
        size += SizeUtils.sizeOf(1, hasTable);
        size += SizeUtils.sizeOf(2, tablePartCount);
        size += SizeUtils.sizeOf(3, indexCount);
        size += SizeUtils.sizeOfPack(4, indexPartCount, SizeUtils::sizeOf);
        return size;
    }
}
