package io.dingodb.sdk.service.entity.meta;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import io.dingodb.sdk.grpc.serializer.Reader;
import io.dingodb.sdk.grpc.serializer.SizeUtils;
import io.dingodb.sdk.grpc.serializer.Writer;
import io.dingodb.sdk.service.entity.Message;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.FieldNameConstants;
import lombok.experimental.SuperBuilder;

@Data
@SuperBuilder
@NoArgsConstructor
@FieldNameConstants
public class TableMetrics implements Message {
    private byte[] maxKey;

    private byte[] minKey;

    private long rowsCount;

    private long partCount;

    private long tableSize;

    private Object ext$;

    @Override
    public void write(CodedOutputStream out) {
        Writer.write(1, rowsCount, out);
        Writer.write(2, minKey, out);
        Writer.write(3, maxKey, out);
        Writer.write(4, partCount, out);
        Writer.write(5, tableSize, out);
    }

    @Override
    public boolean read(CodedInputStream input) {
        int number = 0;
        boolean hasValue = false;
        while((number = Reader.readNumber(input)) != 0) {
            switch(number) {
                case 1: rowsCount = Reader.readLong(input); hasValue = true; break;
                case 2: minKey = Reader.readBytes(input); hasValue = true; break;
                case 3: maxKey = Reader.readBytes(input); hasValue = true; break;
                case 4: partCount = Reader.readLong(input); hasValue = true; break;
                case 5: tableSize = Reader.readLong(input); hasValue = true; break;
                default: Reader.skip(input);
            }
        }
        return hasValue;
    }

    @Override
    public int sizeOf() {
        int size = 0;
        size += SizeUtils.sizeOf(1, rowsCount);
        size += SizeUtils.sizeOf(2, minKey);
        size += SizeUtils.sizeOf(3, maxKey);
        size += SizeUtils.sizeOf(4, partCount);
        size += SizeUtils.sizeOf(5, tableSize);
        return size;
    }
}
