package io.dingodb.sdk.service.entity.meta;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import io.dingodb.sdk.grpc.serializer.Reader;
import io.dingodb.sdk.grpc.serializer.SizeUtils;
import io.dingodb.sdk.grpc.serializer.Writer;
import io.dingodb.sdk.service.entity.Message;
import io.dingodb.sdk.service.entity.common.Engine;
import io.dingodb.sdk.service.entity.common.IndexParameter;
import io.dingodb.sdk.service.entity.common.SchemaState;
import io.dingodb.sdk.service.entity.common.StorageEngine;
import java.util.List;
import java.util.Map;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.FieldNameConstants;
import lombok.experimental.SuperBuilder;

@Data
@SuperBuilder
@NoArgsConstructor
@FieldNameConstants
public class TableDefinition implements Message {
    private StorageEngine storeEngine;

    private String charset;

    private String name;

    private long deleteTimestamp;

    private PartitionRule tablePartition;

    private int version;

    private Engine engine;

    private boolean visible;

    private Map<String, String> properties;

    private String tableType;

    private SchemaState schemaState;

    private long createTimestamp;

    private IndexParameter indexParameter;

    private String collate;

    private int codecVersion;

    private long ttl;

    private long revision;

    private long autoIncrement;

    private long updateTimestamp;

    private String rowFormat;

    private String createSql;

    private List<ColumnDefinition> columns;

    private String comment;

    private int replica;

    private Object ext$;

    @Override
    public void write(CodedOutputStream out) {
        Writer.write(1, name, out);
        Writer.write(2, version, out);
        Writer.write(3, ttl, out);
        Writer.write(4, autoIncrement, out);
        Writer.write(5, createSql, out);
        Writer.write(6, charset, out);
        Writer.write(7, collate, out);
        Writer.write(20, tablePartition, out);
        Writer.write(21, replica, out);
        Writer.write(22, engine, out);
        Writer.write(23, storeEngine, out);
        Writer.write(30, columns, (n, v) -> Writer.write(n, v, out));
        Writer.write(40, properties, out, (n, v) -> Writer.write(n, v, out), (n, v) -> Writer.write(n, v, out), SizeUtils::sizeOf, SizeUtils::sizeOf);
        Writer.write(41, indexParameter, out);
        Writer.write(51, createTimestamp, out);
        Writer.write(52, updateTimestamp, out);
        Writer.write(53, deleteTimestamp, out);
        Writer.write(60, comment, out);
        Writer.write(61, tableType, out);
        Writer.write(62, rowFormat, out);
        Writer.write(63, schemaState, out);
        Writer.write(64, visible, out);
        Writer.write(65, codecVersion, out);
        Writer.write(100, revision, out);
    }

    @Override
    public boolean read(CodedInputStream input) {
        int number = 0;
        boolean hasValue = false;
        while((number = Reader.readNumber(input)) != 0) {
            switch(number) {
                case 1: name = Reader.readString(input); hasValue = true; break;
                case 2: version = Reader.readInt(input); hasValue = true; break;
                case 3: ttl = Reader.readLong(input); hasValue = true; break;
                case 4: autoIncrement = Reader.readLong(input); hasValue = true; break;
                case 5: createSql = Reader.readString(input); hasValue = true; break;
                case 6: charset = Reader.readString(input); hasValue = true; break;
                case 7: collate = Reader.readString(input); hasValue = true; break;
                case 20: tablePartition = Reader.readMessage(new PartitionRule(), input); hasValue = hasValue ? hasValue : tablePartition != null; break;
                case 21: replica = Reader.readInt(input); hasValue = true; break;
                case 22: engine = Engine.forNumber(Reader.readInt(input));hasValue = true; break;
                case 23: storeEngine = StorageEngine.forNumber(Reader.readInt(input));hasValue = true; break;
                case 30: columns = Reader.readList(columns, input, in -> Reader.readMessage(new ColumnDefinition(), in)); hasValue = true; break;
                case 40: properties = Reader.readMap(number, properties, input, Reader::readString, Reader::readString); hasValue = true; break;
                case 41: indexParameter = Reader.readMessage(new IndexParameter(), input); hasValue = hasValue ? hasValue : indexParameter != null; break;
                case 51: createTimestamp = Reader.readLong(input); hasValue = true; break;
                case 52: updateTimestamp = Reader.readLong(input); hasValue = true; break;
                case 53: deleteTimestamp = Reader.readLong(input); hasValue = true; break;
                case 60: comment = Reader.readString(input); hasValue = true; break;
                case 61: tableType = Reader.readString(input); hasValue = true; break;
                case 62: rowFormat = Reader.readString(input); hasValue = true; break;
                case 63: schemaState = SchemaState.forNumber(Reader.readInt(input));hasValue = true; break;
                case 64: visible = Reader.readBoolean(input); hasValue = true; break;
                case 65: codecVersion = Reader.readInt(input); hasValue = true; break;
                case 100: revision = Reader.readLong(input); hasValue = true; break;
                default: Reader.skip(input);
            }
        }
        return hasValue;
    }

    @Override
    public int sizeOf() {
        int size = 0;
        size += SizeUtils.sizeOf(1, name);
        size += SizeUtils.sizeOf(2, version);
        size += SizeUtils.sizeOf(3, ttl);
        size += SizeUtils.sizeOf(4, autoIncrement);
        size += SizeUtils.sizeOf(5, createSql);
        size += SizeUtils.sizeOf(6, charset);
        size += SizeUtils.sizeOf(7, collate);
        size += SizeUtils.sizeOf(20, tablePartition);
        size += SizeUtils.sizeOf(21, replica);
        size += SizeUtils.sizeOf(22, engine);
        size += SizeUtils.sizeOf(23, storeEngine);
        size += SizeUtils.sizeOf(30, columns, SizeUtils::sizeOf);
        size += SizeUtils.sizeOf(40, properties, SizeUtils::sizeOf, SizeUtils::sizeOf);
        size += SizeUtils.sizeOf(41, indexParameter);
        size += SizeUtils.sizeOf(51, createTimestamp);
        size += SizeUtils.sizeOf(52, updateTimestamp);
        size += SizeUtils.sizeOf(53, deleteTimestamp);
        size += SizeUtils.sizeOf(60, comment);
        size += SizeUtils.sizeOf(61, tableType);
        size += SizeUtils.sizeOf(62, rowFormat);
        size += SizeUtils.sizeOf(63, schemaState);
        size += SizeUtils.sizeOf(64, visible);
        size += SizeUtils.sizeOf(65, codecVersion);
        size += SizeUtils.sizeOf(100, revision);
        return size;
    }
}
