package io.dingodb.sdk.service.entity.meta;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import io.dingodb.sdk.grpc.serializer.Reader;
import io.dingodb.sdk.grpc.serializer.SizeUtils;
import io.dingodb.sdk.grpc.serializer.Writer;
import io.dingodb.sdk.service.entity.Message;
import java.util.List;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.FieldNameConstants;
import lombok.experimental.SuperBuilder;

@Data
@SuperBuilder
@NoArgsConstructor
@FieldNameConstants
public class Schema implements Message {
    private long tenantId;

    private String name;

    private DingoCommonId id;

    private List<DingoCommonId> indexIds;

    private long revision;

    private List<DingoCommonId> tableIds;

    private Object ext$;

    @Override
    public void write(CodedOutputStream out) {
        Writer.write(1, id, out);
        Writer.write(2, name, out);
        Writer.write(3, tableIds, (n, v) -> Writer.write(n, v, out));
        Writer.write(4, indexIds, (n, v) -> Writer.write(n, v, out));
        Writer.write(10, revision, out);
        Writer.write(11, tenantId, out);
    }

    @Override
    public boolean read(CodedInputStream input) {
        int number = 0;
        boolean hasValue = false;
        while((number = Reader.readNumber(input)) != 0) {
            switch(number) {
                case 1: id = Reader.readMessage(new DingoCommonId(), input); hasValue = hasValue ? hasValue : id != null; break;
                case 2: name = Reader.readString(input); hasValue = true; break;
                case 3: tableIds = Reader.readList(tableIds, input, in -> Reader.readMessage(new DingoCommonId(), in)); hasValue = true; break;
                case 4: indexIds = Reader.readList(indexIds, input, in -> Reader.readMessage(new DingoCommonId(), in)); hasValue = true; break;
                case 10: revision = Reader.readLong(input); hasValue = true; break;
                case 11: tenantId = Reader.readLong(input); hasValue = true; break;
                default: Reader.skip(input);
            }
        }
        return hasValue;
    }

    @Override
    public int sizeOf() {
        int size = 0;
        size += SizeUtils.sizeOf(1, id);
        size += SizeUtils.sizeOf(2, name);
        size += SizeUtils.sizeOf(3, tableIds, SizeUtils::sizeOf);
        size += SizeUtils.sizeOf(4, indexIds, SizeUtils::sizeOf);
        size += SizeUtils.sizeOf(10, revision);
        size += SizeUtils.sizeOf(11, tenantId);
        return size;
    }
}
