package io.dingodb.sdk.service.entity.meta;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import io.dingodb.sdk.grpc.serializer.Reader;
import io.dingodb.sdk.grpc.serializer.SizeUtils;
import io.dingodb.sdk.grpc.serializer.Writer;
import io.dingodb.sdk.service.entity.Message;
import io.dingodb.sdk.service.entity.common.RegionHeartbeatState;
import io.dingodb.sdk.service.entity.common.RegionRaftStatus;
import io.dingodb.sdk.service.entity.common.RegionState;
import io.dingodb.sdk.service.entity.common.RegionType;
import io.dingodb.sdk.service.entity.common.ReplicaStatus;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.FieldNameConstants;
import lombok.experimental.SuperBuilder;

@Data
@SuperBuilder
@NoArgsConstructor
@FieldNameConstants
public class RegionStatus implements Message {
    private long createTimestamp;

    private long lastUpdateTimestamp;

    private RegionState state;

    private RegionRaftStatus raftStatus;

    private RegionType regionType;

    private ReplicaStatus replicaStatus;

    private RegionHeartbeatState heartbeatState;

    private Object ext$;

    @Override
    public void write(CodedOutputStream out) {
        Writer.write(1, state, out);
        Writer.write(2, raftStatus, out);
        Writer.write(3, replicaStatus, out);
        Writer.write(4, heartbeatState, out);
        Writer.write(5, regionType, out);
        Writer.write(10, createTimestamp, out);
        Writer.write(11, lastUpdateTimestamp, out);
    }

    @Override
    public boolean read(CodedInputStream input) {
        int number = 0;
        boolean hasValue = false;
        while((number = Reader.readNumber(input)) != 0) {
            switch(number) {
                case 1: state = RegionState.forNumber(Reader.readInt(input));hasValue = true; break;
                case 2: raftStatus = RegionRaftStatus.forNumber(Reader.readInt(input));hasValue = true; break;
                case 3: replicaStatus = ReplicaStatus.forNumber(Reader.readInt(input));hasValue = true; break;
                case 4: heartbeatState = RegionHeartbeatState.forNumber(Reader.readInt(input));hasValue = true; break;
                case 5: regionType = RegionType.forNumber(Reader.readInt(input));hasValue = true; break;
                case 10: createTimestamp = Reader.readLong(input); hasValue = true; break;
                case 11: lastUpdateTimestamp = Reader.readLong(input); hasValue = true; break;
                default: Reader.skip(input);
            }
        }
        return hasValue;
    }

    @Override
    public int sizeOf() {
        int size = 0;
        size += SizeUtils.sizeOf(1, state);
        size += SizeUtils.sizeOf(2, raftStatus);
        size += SizeUtils.sizeOf(3, replicaStatus);
        size += SizeUtils.sizeOf(4, heartbeatState);
        size += SizeUtils.sizeOf(5, regionType);
        size += SizeUtils.sizeOf(10, createTimestamp);
        size += SizeUtils.sizeOf(11, lastUpdateTimestamp);
        return size;
    }
}
