package io.dingodb.sdk.service.entity.meta;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import io.dingodb.sdk.grpc.serializer.Reader;
import io.dingodb.sdk.grpc.serializer.SizeUtils;
import io.dingodb.sdk.grpc.serializer.Writer;
import io.dingodb.sdk.service.entity.Message;
import io.dingodb.sdk.service.entity.common.Location;
import io.dingodb.sdk.service.entity.common.Range;
import io.dingodb.sdk.service.entity.common.RegionEpoch;
import java.util.List;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.FieldNameConstants;
import lombok.experimental.SuperBuilder;

@Data
@SuperBuilder
@NoArgsConstructor
@FieldNameConstants
public class RangeDistribution implements Message {
    private List<Location> voters;

    private long storemapEpoch;

    private DingoCommonId id;

    private RegionEpoch regionEpoch;

    private long regionmapEpoch;

    private RegionStatus status;

    private List<Location> learners;

    private Range range;

    private Location leader;

    private Object ext$;

    @Override
    public void write(CodedOutputStream out) {
        Writer.write(1, id, out);
        Writer.write(2, range, out);
        Writer.write(3, leader, out);
        Writer.write(4, voters, (n, v) -> Writer.write(n, v, out));
        Writer.write(5, learners, (n, v) -> Writer.write(n, v, out));
        Writer.write(6, regionmapEpoch, out);
        Writer.write(7, storemapEpoch, out);
        Writer.write(8, regionEpoch, out);
        Writer.write(9, status, out);
    }

    @Override
    public boolean read(CodedInputStream input) {
        int number = 0;
        boolean hasValue = false;
        while((number = Reader.readNumber(input)) != 0) {
            switch(number) {
                case 1: id = Reader.readMessage(new DingoCommonId(), input); hasValue = hasValue ? hasValue : id != null; break;
                case 2: range = Reader.readMessage(new Range(), input); hasValue = hasValue ? hasValue : range != null; break;
                case 3: leader = Reader.readMessage(new Location(), input); hasValue = hasValue ? hasValue : leader != null; break;
                case 4: voters = Reader.readList(voters, input, in -> Reader.readMessage(new Location(), in)); hasValue = true; break;
                case 5: learners = Reader.readList(learners, input, in -> Reader.readMessage(new Location(), in)); hasValue = true; break;
                case 6: regionmapEpoch = Reader.readLong(input); hasValue = true; break;
                case 7: storemapEpoch = Reader.readLong(input); hasValue = true; break;
                case 8: regionEpoch = Reader.readMessage(new RegionEpoch(), input); hasValue = hasValue ? hasValue : regionEpoch != null; break;
                case 9: status = Reader.readMessage(new RegionStatus(), input); hasValue = hasValue ? hasValue : status != null; break;
                default: Reader.skip(input);
            }
        }
        return hasValue;
    }

    @Override
    public int sizeOf() {
        int size = 0;
        size += SizeUtils.sizeOf(1, id);
        size += SizeUtils.sizeOf(2, range);
        size += SizeUtils.sizeOf(3, leader);
        size += SizeUtils.sizeOf(4, voters, SizeUtils::sizeOf);
        size += SizeUtils.sizeOf(5, learners, SizeUtils::sizeOf);
        size += SizeUtils.sizeOf(6, regionmapEpoch);
        size += SizeUtils.sizeOf(7, storemapEpoch);
        size += SizeUtils.sizeOf(8, regionEpoch);
        size += SizeUtils.sizeOf(9, status);
        return size;
    }
}
