package io.dingodb.sdk.service.entity.meta;

import io.dingodb.sdk.service.entity.Numeric;

public enum PartitionStrategy implements Numeric {
    UNRECOGNIZED(-1),

    PT_STRATEGY_RANGE(0),

    PT_STRATEGY_HASH(1);

    public final Integer number;

    private Object ext$;

    private PartitionStrategy(Integer number) {
        this.number = number;
    }

    @Override
    public int number() {
        return number;
    }

    public static PartitionStrategy forNumber(int number) {
        switch(number) {
            case -1: return UNRECOGNIZED;
            case 0: return PT_STRATEGY_RANGE;
            case 1: return PT_STRATEGY_HASH;
            default: return null;
        }
    }
}
