package io.dingodb.sdk.service.entity.meta;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import io.dingodb.sdk.grpc.serializer.Reader;
import io.dingodb.sdk.grpc.serializer.SizeUtils;
import io.dingodb.sdk.grpc.serializer.Writer;
import io.dingodb.sdk.service.entity.Message;
import java.util.List;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.FieldNameConstants;
import lombok.experimental.SuperBuilder;

@Data
@SuperBuilder
@NoArgsConstructor
@FieldNameConstants
public class PartitionRule implements Message {
    private PartitionStrategy strategy;

    private List<String> columns;

    private List<Partition> partitions;

    private Object ext$;

    @Override
    public void write(CodedOutputStream out) {
        Writer.write(1, columns, (n, v) -> Writer.write(n, v, out));
        Writer.write(2, strategy, out);
        Writer.write(10, partitions, (n, v) -> Writer.write(n, v, out));
    }

    @Override
    public boolean read(CodedInputStream input) {
        int number = 0;
        boolean hasValue = false;
        while((number = Reader.readNumber(input)) != 0) {
            switch(number) {
                case 1: columns = Reader.readList(columns, input, Reader::readString); hasValue = true; break;
                case 2: strategy = PartitionStrategy.forNumber(Reader.readInt(input));hasValue = true; break;
                case 10: partitions = Reader.readList(partitions, input, in -> Reader.readMessage(new Partition(), in)); hasValue = true; break;
                default: Reader.skip(input);
            }
        }
        return hasValue;
    }

    @Override
    public int sizeOf() {
        int size = 0;
        size += SizeUtils.sizeOf(1, columns, SizeUtils::sizeOf);
        size += SizeUtils.sizeOf(2, strategy);
        size += SizeUtils.sizeOf(10, partitions, SizeUtils::sizeOf);
        return size;
    }
}
