package io.dingodb.sdk.service.entity.meta;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import io.dingodb.sdk.grpc.serializer.Reader;
import io.dingodb.sdk.grpc.serializer.SizeUtils;
import io.dingodb.sdk.grpc.serializer.Writer;
import io.dingodb.sdk.service.entity.Message;
import io.dingodb.sdk.service.entity.common.Range;
import io.dingodb.sdk.service.entity.common.SchemaState;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.FieldNameConstants;
import lombok.experimental.SuperBuilder;

@Data
@SuperBuilder
@NoArgsConstructor
@FieldNameConstants
public class Partition implements Message {
    private SchemaState schemaState;

    private String name;

    private DingoCommonId id;

    private Range range;

    private Object ext$;

    @Override
    public void write(CodedOutputStream out) {
        Writer.write(1, id, out);
        Writer.write(2, range, out);
        Writer.write(3, name, out);
        Writer.write(4, schemaState, out);
    }

    @Override
    public boolean read(CodedInputStream input) {
        int number = 0;
        boolean hasValue = false;
        while((number = Reader.readNumber(input)) != 0) {
            switch(number) {
                case 1: id = Reader.readMessage(new DingoCommonId(), input); hasValue = hasValue ? hasValue : id != null; break;
                case 2: range = Reader.readMessage(new Range(), input); hasValue = hasValue ? hasValue : range != null; break;
                case 3: name = Reader.readString(input); hasValue = true; break;
                case 4: schemaState = SchemaState.forNumber(Reader.readInt(input));hasValue = true; break;
                default: Reader.skip(input);
            }
        }
        return hasValue;
    }

    @Override
    public int sizeOf() {
        int size = 0;
        size += SizeUtils.sizeOf(1, id);
        size += SizeUtils.sizeOf(2, range);
        size += SizeUtils.sizeOf(3, name);
        size += SizeUtils.sizeOf(4, schemaState);
        return size;
    }
}
