package io.dingodb.sdk.service.entity.meta;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import io.dingodb.sdk.grpc.serializer.Reader;
import io.dingodb.sdk.grpc.serializer.SizeUtils;
import io.dingodb.sdk.grpc.serializer.Writer;
import io.dingodb.sdk.service.entity.Message;
import java.util.List;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.FieldNameConstants;
import lombok.experimental.SuperBuilder;

@Data
@SuperBuilder
@NoArgsConstructor
@FieldNameConstants
public class MetaEventTableIndex implements Message {
    private long id;

    private long revision;

    private List<DingoCommonId> tableIds;

    private Object ext$;

    @Override
    public void write(CodedOutputStream out) {
        Writer.write(1, id, out);
        Writer.write(2, tableIds, (n, v) -> Writer.write(n, v, out));
        Writer.write(3, revision, out);
    }

    @Override
    public boolean read(CodedInputStream input) {
        int number = 0;
        boolean hasValue = false;
        while((number = Reader.readNumber(input)) != 0) {
            switch(number) {
                case 1: id = Reader.readLong(input); hasValue = true; break;
                case 2: tableIds = Reader.readList(tableIds, input, in -> Reader.readMessage(new DingoCommonId(), in)); hasValue = true; break;
                case 3: revision = Reader.readLong(input); hasValue = true; break;
                default: Reader.skip(input);
            }
        }
        return hasValue;
    }

    @Override
    public int sizeOf() {
        int size = 0;
        size += SizeUtils.sizeOf(1, id);
        size += SizeUtils.sizeOf(2, tableIds, SizeUtils::sizeOf);
        size += SizeUtils.sizeOf(3, revision);
        return size;
    }
}
