package io.dingodb.sdk.service.entity.meta;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import io.dingodb.sdk.grpc.serializer.Reader;
import io.dingodb.sdk.grpc.serializer.SizeUtils;
import io.dingodb.sdk.grpc.serializer.Writer;
import io.dingodb.sdk.service.entity.Message;
import io.dingodb.sdk.service.entity.common.RegionDefinition;
import io.dingodb.sdk.service.entity.common.RegionState;
import io.dingodb.sdk.service.entity.common.RegionType;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.FieldNameConstants;
import lombok.experimental.SuperBuilder;

@Data
@SuperBuilder
@NoArgsConstructor
@FieldNameConstants
public class MetaEventRegion implements Message {
    private long createTimestamp;

    private RegionState state;

    private long id;

    private long epoch;

    private RegionType regionType;

    private RegionDefinition definition;

    private long deletedTimestamp;

    private Object ext$;

    @Override
    public void write(CodedOutputStream out) {
        Writer.write(1, id, out);
        Writer.write(2, epoch, out);
        Writer.write(3, regionType, out);
        Writer.write(4, definition, out);
        Writer.write(10, state, out);
        Writer.write(20, createTimestamp, out);
        Writer.write(21, deletedTimestamp, out);
    }

    @Override
    public boolean read(CodedInputStream input) {
        int number = 0;
        boolean hasValue = false;
        while((number = Reader.readNumber(input)) != 0) {
            switch(number) {
                case 1: id = Reader.readLong(input); hasValue = true; break;
                case 2: epoch = Reader.readLong(input); hasValue = true; break;
                case 3: regionType = RegionType.forNumber(Reader.readInt(input));hasValue = true; break;
                case 4: definition = Reader.readMessage(new RegionDefinition(), input); hasValue = hasValue ? hasValue : definition != null; break;
                case 10: state = RegionState.forNumber(Reader.readInt(input));hasValue = true; break;
                case 20: createTimestamp = Reader.readLong(input); hasValue = true; break;
                case 21: deletedTimestamp = Reader.readLong(input); hasValue = true; break;
                default: Reader.skip(input);
            }
        }
        return hasValue;
    }

    @Override
    public int sizeOf() {
        int size = 0;
        size += SizeUtils.sizeOf(1, id);
        size += SizeUtils.sizeOf(2, epoch);
        size += SizeUtils.sizeOf(3, regionType);
        size += SizeUtils.sizeOf(4, definition);
        size += SizeUtils.sizeOf(10, state);
        size += SizeUtils.sizeOf(20, createTimestamp);
        size += SizeUtils.sizeOf(21, deletedTimestamp);
        return size;
    }
}
