package io.dingodb.sdk.service.entity.meta;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import io.dingodb.sdk.grpc.serializer.Reader;
import io.dingodb.sdk.grpc.serializer.SizeUtils;
import io.dingodb.sdk.grpc.serializer.Writer;
import io.dingodb.sdk.service.entity.Message;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.FieldNameConstants;
import lombok.experimental.SuperBuilder;

@Data
@SuperBuilder
@NoArgsConstructor
@FieldNameConstants
public class MetaEventIndex implements Message {
    private long schemaId;

    private long id;

    private long parentTableId;

    private TableDefinition definition;

    private Object ext$;

    @Override
    public void write(CodedOutputStream out) {
        Writer.write(1, id, out);
        Writer.write(2, definition, out);
        Writer.write(3, schemaId, out);
        Writer.write(4, parentTableId, out);
    }

    @Override
    public boolean read(CodedInputStream input) {
        int number = 0;
        boolean hasValue = false;
        while((number = Reader.readNumber(input)) != 0) {
            switch(number) {
                case 1: id = Reader.readLong(input); hasValue = true; break;
                case 2: definition = Reader.readMessage(new TableDefinition(), input); hasValue = hasValue ? hasValue : definition != null; break;
                case 3: schemaId = Reader.readLong(input); hasValue = true; break;
                case 4: parentTableId = Reader.readLong(input); hasValue = true; break;
                default: Reader.skip(input);
            }
        }
        return hasValue;
    }

    @Override
    public int sizeOf() {
        int size = 0;
        size += SizeUtils.sizeOf(1, id);
        size += SizeUtils.sizeOf(2, definition);
        size += SizeUtils.sizeOf(3, schemaId);
        size += SizeUtils.sizeOf(4, parentTableId);
        return size;
    }
}
