package io.dingodb.sdk.service.entity.meta;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import io.dingodb.sdk.grpc.serializer.Reader;
import io.dingodb.sdk.grpc.serializer.SizeUtils;
import io.dingodb.sdk.grpc.serializer.Writer;
import io.dingodb.sdk.service.entity.Message;
import io.dingodb.sdk.service.entity.Numeric;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.FieldNameConstants;
import lombok.experimental.SuperBuilder;

@Data
@SuperBuilder
@NoArgsConstructor
@FieldNameConstants
public class MetaEvent implements Message {
    private EventNest event;

    private MetaEventType eventType;

    private Object ext$;

    @Override
    public void write(CodedOutputStream out) {
        Writer.write(1, eventType, out);
        Writer.write(event, event, out);
    }

    @Override
    public boolean read(CodedInputStream input) {
        int number = 0;
        boolean hasValue = false;
        while((number = Reader.readNumber(input)) != 0) {
            switch(number) {
                case 1: eventType = MetaEventType.forNumber(Reader.readInt(input));hasValue = true; break;
                case 2: event = Reader.readMessage(new EventNest.Schema(), input); hasValue = hasValue ? hasValue : event != null; break;
                case 3: event = Reader.readMessage(new EventNest.Table(), input); hasValue = hasValue ? hasValue : event != null; break;
                case 4: event = Reader.readMessage(new EventNest.Index(), input); hasValue = hasValue ? hasValue : event != null; break;
                case 5: event = Reader.readMessage(new EventNest.TableIndex(), input); hasValue = hasValue ? hasValue : event != null; break;
                case 6: event = Reader.readMessage(new EventNest.Region(), input); hasValue = hasValue ? hasValue : event != null; break;
                case 7: event = Reader.readMessage(new EventNest.Tenant(), input); hasValue = hasValue ? hasValue : event != null; break;
                default: Reader.skip(input);
            }
        }
        return hasValue;
    }

    @Override
    public int sizeOf() {
        int size = 0;
        size += SizeUtils.sizeOf(1, eventType);
        size += SizeUtils.sizeOf(event, event);
        return size;
    }

    public interface EventNest extends Message, Numeric {
        int number();

        Nest nest();

        @NoArgsConstructor
        @SuperBuilder
        class Schema extends MetaEventSchema implements EventNest {
            public static final int number = 2;

            @Override
            public int number() {
                return 2;
            }

            @Override
            public Nest nest() {
                return Nest.SCHEMA;
            }
        }

        @NoArgsConstructor
        @SuperBuilder
        class Table extends MetaEventTable implements EventNest {
            public static final int number = 3;

            @Override
            public int number() {
                return 3;
            }

            @Override
            public Nest nest() {
                return Nest.TABLE;
            }
        }

        @NoArgsConstructor
        @SuperBuilder
        class Index extends MetaEventIndex implements EventNest {
            public static final int number = 4;

            @Override
            public int number() {
                return 4;
            }

            @Override
            public Nest nest() {
                return Nest.INDEX;
            }
        }

        @NoArgsConstructor
        @SuperBuilder
        class TableIndex extends MetaEventTableIndex implements EventNest {
            public static final int number = 5;

            @Override
            public int number() {
                return 5;
            }

            @Override
            public Nest nest() {
                return Nest.TABLE_INDEX;
            }
        }

        @NoArgsConstructor
        @SuperBuilder
        class Region extends MetaEventRegion implements EventNest {
            public static final int number = 6;

            @Override
            public int number() {
                return 6;
            }

            @Override
            public Nest nest() {
                return Nest.REGION;
            }
        }

        @NoArgsConstructor
        @SuperBuilder
        class Tenant extends MetaEventTenant implements EventNest {
            public static final int number = 7;

            @Override
            public int number() {
                return 7;
            }

            @Override
            public Nest nest() {
                return Nest.TENANT;
            }
        }

        enum Nest implements Numeric {
            SCHEMA(2),

            TABLE(3),

            INDEX(4),

            TABLE_INDEX(5),

            REGION(6),

            TENANT(7);

            public final Integer number;

            private Nest(Integer number) {
                this.number = number;
            }

            @Override
            public int number() {
                return number;
            }
        }
    }
}
