package io.dingodb.sdk.service.entity.meta;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import io.dingodb.sdk.grpc.serializer.Reader;
import io.dingodb.sdk.grpc.serializer.SizeUtils;
import io.dingodb.sdk.grpc.serializer.Writer;
import io.dingodb.sdk.service.entity.Message;
import java.util.List;
import java.util.Map;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.FieldNameConstants;
import lombok.experimental.SuperBuilder;

@Data
@SuperBuilder
@NoArgsConstructor
@FieldNameConstants
public class MetaALL implements Message {
    private Map<String, TablesAndIndexes> tablesAndIndexes;

    private Map<Long, Schemas> schemas;

    private List<Tenant> tenants;

    private Object ext$;

    @Override
    public void write(CodedOutputStream out) {
        Writer.write(1, tenants, (n, v) -> Writer.write(n, v, out));
        Writer.write(2, schemas, out, (n, v) -> Writer.write(n, v, out), (n, v) -> Writer.write(n, v, out), SizeUtils::sizeOf, SizeUtils::sizeOf);
        Writer.write(3, tablesAndIndexes, out, (n, v) -> Writer.write(n, v, out), (n, v) -> Writer.write(n, v, out), SizeUtils::sizeOf, SizeUtils::sizeOf);
    }

    @Override
    public boolean read(CodedInputStream input) {
        int number = 0;
        boolean hasValue = false;
        while((number = Reader.readNumber(input)) != 0) {
            switch(number) {
                case 1: tenants = Reader.readList(tenants, input, in -> Reader.readMessage(new Tenant(), in)); hasValue = true; break;
                case 2: schemas = Reader.readMap(number, schemas, input, Reader::readLong, in -> Reader.readMessage(new Schemas(), in)); hasValue = true; break;
                case 3: tablesAndIndexes = Reader.readMap(number, tablesAndIndexes, input, Reader::readString, in -> Reader.readMessage(new TablesAndIndexes(), in)); hasValue = true; break;
                default: Reader.skip(input);
            }
        }
        return hasValue;
    }

    @Override
    public int sizeOf() {
        int size = 0;
        size += SizeUtils.sizeOf(1, tenants, SizeUtils::sizeOf);
        size += SizeUtils.sizeOf(2, schemas, SizeUtils::sizeOf, SizeUtils::sizeOf);
        size += SizeUtils.sizeOf(3, tablesAndIndexes, SizeUtils::sizeOf, SizeUtils::sizeOf);
        return size;
    }
}
