package io.dingodb.sdk.service.entity.meta;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import io.dingodb.sdk.grpc.serializer.Reader;
import io.dingodb.sdk.grpc.serializer.SizeUtils;
import io.dingodb.sdk.grpc.serializer.Writer;
import io.dingodb.sdk.service.entity.Message;
import io.dingodb.sdk.service.entity.common.VectorIndexType;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.FieldNameConstants;
import lombok.experimental.SuperBuilder;

@Data
@SuperBuilder
@NoArgsConstructor
@FieldNameConstants
public class IndexMetrics implements Message {
    private long deletedCount;

    private long minId;

    private long currentCount;

    private long maxId;

    private byte[] maxKey;

    private byte[] minKey;

    private VectorIndexType vectorIndexType;

    private long rowsCount;

    private long partCount;

    private long memoryBytes;

    private Object ext$;

    @Override
    public void write(CodedOutputStream out) {
        Writer.write(1, rowsCount, out);
        Writer.write(2, minKey, out);
        Writer.write(3, maxKey, out);
        Writer.write(4, partCount, out);
        Writer.write(20, vectorIndexType, out);
        Writer.write(21, currentCount, out);
        Writer.write(22, deletedCount, out);
        Writer.write(23, maxId, out);
        Writer.write(24, minId, out);
        Writer.write(25, memoryBytes, out);
    }

    @Override
    public boolean read(CodedInputStream input) {
        int number = 0;
        boolean hasValue = false;
        while((number = Reader.readNumber(input)) != 0) {
            switch(number) {
                case 1: rowsCount = Reader.readLong(input); hasValue = true; break;
                case 2: minKey = Reader.readBytes(input); hasValue = true; break;
                case 3: maxKey = Reader.readBytes(input); hasValue = true; break;
                case 4: partCount = Reader.readLong(input); hasValue = true; break;
                case 20: vectorIndexType = VectorIndexType.forNumber(Reader.readInt(input));hasValue = true; break;
                case 21: currentCount = Reader.readLong(input); hasValue = true; break;
                case 22: deletedCount = Reader.readLong(input); hasValue = true; break;
                case 23: maxId = Reader.readLong(input); hasValue = true; break;
                case 24: minId = Reader.readLong(input); hasValue = true; break;
                case 25: memoryBytes = Reader.readLong(input); hasValue = true; break;
                default: Reader.skip(input);
            }
        }
        return hasValue;
    }

    @Override
    public int sizeOf() {
        int size = 0;
        size += SizeUtils.sizeOf(1, rowsCount);
        size += SizeUtils.sizeOf(2, minKey);
        size += SizeUtils.sizeOf(3, maxKey);
        size += SizeUtils.sizeOf(4, partCount);
        size += SizeUtils.sizeOf(20, vectorIndexType);
        size += SizeUtils.sizeOf(21, currentCount);
        size += SizeUtils.sizeOf(22, deletedCount);
        size += SizeUtils.sizeOf(23, maxId);
        size += SizeUtils.sizeOf(24, minId);
        size += SizeUtils.sizeOf(25, memoryBytes);
        return size;
    }
}
