package io.dingodb.sdk.service.entity.meta;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import io.dingodb.sdk.grpc.serializer.Reader;
import io.dingodb.sdk.grpc.serializer.SizeUtils;
import io.dingodb.sdk.grpc.serializer.Writer;
import io.dingodb.sdk.service.entity.Message;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.FieldNameConstants;
import lombok.experimental.SuperBuilder;

@Data
@SuperBuilder
@NoArgsConstructor
@FieldNameConstants
public class IndexDefinitionWithId implements Message {
    private IndexDefinition indexDefinition;

    private long tenantId;

    private DingoCommonId indexId;

    private Object ext$;

    @Override
    public void write(CodedOutputStream out) {
        Writer.write(1, indexId, out);
        Writer.write(2, indexDefinition, out);
        Writer.write(3, tenantId, out);
    }

    @Override
    public boolean read(CodedInputStream input) {
        int number = 0;
        boolean hasValue = false;
        while((number = Reader.readNumber(input)) != 0) {
            switch(number) {
                case 1: indexId = Reader.readMessage(new DingoCommonId(), input); hasValue = hasValue ? hasValue : indexId != null; break;
                case 2: indexDefinition = Reader.readMessage(new IndexDefinition(), input); hasValue = hasValue ? hasValue : indexDefinition != null; break;
                case 3: tenantId = Reader.readLong(input); hasValue = true; break;
                default: Reader.skip(input);
            }
        }
        return hasValue;
    }

    @Override
    public int sizeOf() {
        int size = 0;
        size += SizeUtils.sizeOf(1, indexId);
        size += SizeUtils.sizeOf(2, indexDefinition);
        size += SizeUtils.sizeOf(3, tenantId);
        return size;
    }
}
