package io.dingodb.sdk.service.entity.meta;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import io.dingodb.sdk.grpc.serializer.Reader;
import io.dingodb.sdk.grpc.serializer.SizeUtils;
import io.dingodb.sdk.grpc.serializer.Writer;
import io.dingodb.sdk.service.entity.Message;
import io.dingodb.sdk.service.entity.common.Engine;
import io.dingodb.sdk.service.entity.common.IndexParameter;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.FieldNameConstants;
import lombok.experimental.SuperBuilder;

@Data
@SuperBuilder
@NoArgsConstructor
@FieldNameConstants
public class IndexDefinition implements Message {
    private String name;

    private boolean withAutoIncrment;

    private IndexParameter indexParameter;

    private int version;

    private Engine engine;

    private long revision;

    private long autoIncrement;

    private PartitionRule indexPartition;

    private int replica;

    private Object ext$;

    @Override
    public void write(CodedOutputStream out) {
        Writer.write(1, name, out);
        Writer.write(2, version, out);
        Writer.write(3, indexPartition, out);
        Writer.write(4, replica, out);
        Writer.write(5, indexParameter, out);
        Writer.write(6, withAutoIncrment, out);
        Writer.write(7, autoIncrement, out);
        Writer.write(8, engine, out);
        Writer.write(20, revision, out);
    }

    @Override
    public boolean read(CodedInputStream input) {
        int number = 0;
        boolean hasValue = false;
        while((number = Reader.readNumber(input)) != 0) {
            switch(number) {
                case 1: name = Reader.readString(input); hasValue = true; break;
                case 2: version = Reader.readInt(input); hasValue = true; break;
                case 3: indexPartition = Reader.readMessage(new PartitionRule(), input); hasValue = hasValue ? hasValue : indexPartition != null; break;
                case 4: replica = Reader.readInt(input); hasValue = true; break;
                case 5: indexParameter = Reader.readMessage(new IndexParameter(), input); hasValue = hasValue ? hasValue : indexParameter != null; break;
                case 6: withAutoIncrment = Reader.readBoolean(input); hasValue = true; break;
                case 7: autoIncrement = Reader.readLong(input); hasValue = true; break;
                case 8: engine = Engine.forNumber(Reader.readInt(input));hasValue = true; break;
                case 20: revision = Reader.readLong(input); hasValue = true; break;
                default: Reader.skip(input);
            }
        }
        return hasValue;
    }

    @Override
    public int sizeOf() {
        int size = 0;
        size += SizeUtils.sizeOf(1, name);
        size += SizeUtils.sizeOf(2, version);
        size += SizeUtils.sizeOf(3, indexPartition);
        size += SizeUtils.sizeOf(4, replica);
        size += SizeUtils.sizeOf(5, indexParameter);
        size += SizeUtils.sizeOf(6, withAutoIncrment);
        size += SizeUtils.sizeOf(7, autoIncrement);
        size += SizeUtils.sizeOf(8, engine);
        size += SizeUtils.sizeOf(20, revision);
        return size;
    }
}
