package io.dingodb.sdk.service.entity.meta;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import io.dingodb.sdk.grpc.serializer.Reader;
import io.dingodb.sdk.grpc.serializer.SizeUtils;
import io.dingodb.sdk.grpc.serializer.Writer;
import io.dingodb.sdk.service.entity.Message;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.FieldNameConstants;
import lombok.experimental.SuperBuilder;

@Data
@SuperBuilder
@NoArgsConstructor
@FieldNameConstants
public class DingoCommonId implements Message {
    private EntityType entityType;

    private long entityId;

    private long parentEntityId;

    private Object ext$;

    @Override
    public void write(CodedOutputStream out) {
        Writer.write(1, entityType, out);
        Writer.write(2, parentEntityId, out);
        Writer.write(3, entityId, out);
    }

    @Override
    public boolean read(CodedInputStream input) {
        int number = 0;
        boolean hasValue = false;
        while((number = Reader.readNumber(input)) != 0) {
            switch(number) {
                case 1: entityType = EntityType.forNumber(Reader.readInt(input));hasValue = true; break;
                case 2: parentEntityId = Reader.readLong(input); hasValue = true; break;
                case 3: entityId = Reader.readLong(input); hasValue = true; break;
                default: Reader.skip(input);
            }
        }
        return hasValue;
    }

    @Override
    public int sizeOf() {
        int size = 0;
        size += SizeUtils.sizeOf(1, entityType);
        size += SizeUtils.sizeOf(2, parentEntityId);
        size += SizeUtils.sizeOf(3, entityId);
        return size;
    }
}
