package io.dingodb.sdk.service.entity.meta;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import io.dingodb.sdk.grpc.serializer.Reader;
import io.dingodb.sdk.grpc.serializer.SizeUtils;
import io.dingodb.sdk.grpc.serializer.Writer;
import io.dingodb.sdk.service.entity.Message;
import io.dingodb.sdk.service.entity.common.RequestInfo;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.FieldNameConstants;
import lombok.experimental.SuperBuilder;

@Data
@SuperBuilder
@NoArgsConstructor
@FieldNameConstants
public class CreateTableRequest implements Message, Message.Request {
    private DingoCommonId schemaId;

    private TableDefinition tableDefinition;

    private DingoCommonId tableId;

    private RequestInfo requestInfo;

    private Object ext$;

    @Override
    public void write(CodedOutputStream out) {
        Writer.write(1, requestInfo, out);
        Writer.write(2, schemaId, out);
        Writer.write(3, tableId, out);
        Writer.write(4, tableDefinition, out);
    }

    @Override
    public boolean read(CodedInputStream input) {
        int number = 0;
        boolean hasValue = false;
        while((number = Reader.readNumber(input)) != 0) {
            switch(number) {
                case 1: requestInfo = Reader.readMessage(new RequestInfo(), input); hasValue = hasValue ? hasValue : requestInfo != null; break;
                case 2: schemaId = Reader.readMessage(new DingoCommonId(), input); hasValue = hasValue ? hasValue : schemaId != null; break;
                case 3: tableId = Reader.readMessage(new DingoCommonId(), input); hasValue = hasValue ? hasValue : tableId != null; break;
                case 4: tableDefinition = Reader.readMessage(new TableDefinition(), input); hasValue = hasValue ? hasValue : tableDefinition != null; break;
                default: Reader.skip(input);
            }
        }
        return hasValue;
    }

    @Override
    public int sizeOf() {
        int size = 0;
        size += SizeUtils.sizeOf(1, requestInfo);
        size += SizeUtils.sizeOf(2, schemaId);
        size += SizeUtils.sizeOf(3, tableId);
        size += SizeUtils.sizeOf(4, tableDefinition);
        return size;
    }
}
