package io.dingodb.sdk.service.entity.meta;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import io.dingodb.sdk.grpc.serializer.Reader;
import io.dingodb.sdk.grpc.serializer.SizeUtils;
import io.dingodb.sdk.grpc.serializer.Writer;
import io.dingodb.sdk.service.entity.Message;
import io.dingodb.sdk.service.entity.common.RequestInfo;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.FieldNameConstants;
import lombok.experimental.SuperBuilder;

@Data
@SuperBuilder
@NoArgsConstructor
@FieldNameConstants
public class CreateIndexRequest implements Message, Message.Request {
    private IndexDefinition indexDefinition;

    private DingoCommonId schemaId;

    private DingoCommonId indexId;

    private RequestInfo requestInfo;

    private Object ext$;

    @Override
    public void write(CodedOutputStream out) {
        Writer.write(1, requestInfo, out);
        Writer.write(2, schemaId, out);
        Writer.write(3, indexId, out);
        Writer.write(4, indexDefinition, out);
    }

    @Override
    public boolean read(CodedInputStream input) {
        int number = 0;
        boolean hasValue = false;
        while((number = Reader.readNumber(input)) != 0) {
            switch(number) {
                case 1: requestInfo = Reader.readMessage(new RequestInfo(), input); hasValue = hasValue ? hasValue : requestInfo != null; break;
                case 2: schemaId = Reader.readMessage(new DingoCommonId(), input); hasValue = hasValue ? hasValue : schemaId != null; break;
                case 3: indexId = Reader.readMessage(new DingoCommonId(), input); hasValue = hasValue ? hasValue : indexId != null; break;
                case 4: indexDefinition = Reader.readMessage(new IndexDefinition(), input); hasValue = hasValue ? hasValue : indexDefinition != null; break;
                default: Reader.skip(input);
            }
        }
        return hasValue;
    }

    @Override
    public int sizeOf() {
        int size = 0;
        size += SizeUtils.sizeOf(1, requestInfo);
        size += SizeUtils.sizeOf(2, schemaId);
        size += SizeUtils.sizeOf(3, indexId);
        size += SizeUtils.sizeOf(4, indexDefinition);
        return size;
    }
}
