package io.dingodb.sdk.service.entity.meta;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import io.dingodb.sdk.grpc.serializer.Reader;
import io.dingodb.sdk.grpc.serializer.SizeUtils;
import io.dingodb.sdk.grpc.serializer.Writer;
import io.dingodb.sdk.service.entity.Message;
import io.dingodb.sdk.service.entity.common.SchemaState;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.FieldNameConstants;
import lombok.experimental.SuperBuilder;

@Data
@SuperBuilder
@NoArgsConstructor
@FieldNameConstants
public class ColumnDefinition implements Message {
    private int deleteVersion;

    private int createVersion;

    private String name;

    private boolean isAutoIncrement;

    private int state;

    private boolean nullable;

    private int scale;

    private int precision;

    private SchemaState schemaState;

    private int indexOfKey;

    private boolean hasDefaultVal;

    private String defaultVal;

    private String sqlType;

    private String elementType;

    private String comment;

    private int updateVersion;

    private Object ext$;

    @Override
    public void write(CodedOutputStream out) {
        Writer.write(1, name, out);
        Writer.write(2, sqlType, out);
        Writer.write(3, elementType, out);
        Writer.write(4, precision, out);
        Writer.write(5, scale, out);
        Writer.write(6, nullable, out);
        Writer.write(7, indexOfKey, out);
        Writer.write(8, hasDefaultVal, out);
        Writer.write(9, defaultVal, out);
        Writer.write(10, isAutoIncrement, out);
        Writer.write(20, state, out);
        Writer.write(30, comment, out);
        Writer.write(31, schemaState, out);
        Writer.write(51, createVersion, out);
        Writer.write(52, updateVersion, out);
        Writer.write(53, deleteVersion, out);
    }

    @Override
    public boolean read(CodedInputStream input) {
        int number = 0;
        boolean hasValue = false;
        while((number = Reader.readNumber(input)) != 0) {
            switch(number) {
                case 1: name = Reader.readString(input); hasValue = true; break;
                case 2: sqlType = Reader.readString(input); hasValue = true; break;
                case 3: elementType = Reader.readString(input); hasValue = true; break;
                case 4: precision = Reader.readInt(input); hasValue = true; break;
                case 5: scale = Reader.readInt(input); hasValue = true; break;
                case 6: nullable = Reader.readBoolean(input); hasValue = true; break;
                case 7: indexOfKey = Reader.readInt(input); hasValue = true; break;
                case 8: hasDefaultVal = Reader.readBoolean(input); hasValue = true; break;
                case 9: defaultVal = Reader.readString(input); hasValue = true; break;
                case 10: isAutoIncrement = Reader.readBoolean(input); hasValue = true; break;
                case 20: state = Reader.readInt(input); hasValue = true; break;
                case 30: comment = Reader.readString(input); hasValue = true; break;
                case 31: schemaState = SchemaState.forNumber(Reader.readInt(input));hasValue = true; break;
                case 51: createVersion = Reader.readInt(input); hasValue = true; break;
                case 52: updateVersion = Reader.readInt(input); hasValue = true; break;
                case 53: deleteVersion = Reader.readInt(input); hasValue = true; break;
                default: Reader.skip(input);
            }
        }
        return hasValue;
    }

    @Override
    public int sizeOf() {
        int size = 0;
        size += SizeUtils.sizeOf(1, name);
        size += SizeUtils.sizeOf(2, sqlType);
        size += SizeUtils.sizeOf(3, elementType);
        size += SizeUtils.sizeOf(4, precision);
        size += SizeUtils.sizeOf(5, scale);
        size += SizeUtils.sizeOf(6, nullable);
        size += SizeUtils.sizeOf(7, indexOfKey);
        size += SizeUtils.sizeOf(8, hasDefaultVal);
        size += SizeUtils.sizeOf(9, defaultVal);
        size += SizeUtils.sizeOf(10, isAutoIncrement);
        size += SizeUtils.sizeOf(20, state);
        size += SizeUtils.sizeOf(30, comment);
        size += SizeUtils.sizeOf(31, schemaState);
        size += SizeUtils.sizeOf(51, createVersion);
        size += SizeUtils.sizeOf(52, updateVersion);
        size += SizeUtils.sizeOf(53, deleteVersion);
        return size;
    }
}
