package io.dingodb.sdk.service.entity.index;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import io.dingodb.sdk.grpc.serializer.Reader;
import io.dingodb.sdk.grpc.serializer.SizeUtils;
import io.dingodb.sdk.grpc.serializer.Writer;
import io.dingodb.sdk.service.entity.Message;
import io.dingodb.sdk.service.entity.common.RequestInfo;
import io.dingodb.sdk.service.entity.common.VectorScalardata;
import io.dingodb.sdk.service.entity.store.Context;
import java.util.List;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.FieldNameConstants;
import lombok.experimental.SuperBuilder;

@Data
@SuperBuilder
@NoArgsConstructor
@FieldNameConstants
public class VectorScanQueryRequest implements Message, Message.Request, Message.StoreRequest {
    private boolean useScalarFilter;

    private long vectorIdEnd;

    private boolean withoutTableData;

    private boolean withoutVectorData;

    private RequestInfo requestInfo;

    private long vectorIdStart;

    private boolean isReverseScan;

    private List<String> selectedKeys;

    private Context context;

    private long ts;

    private VectorScalardata scalarForFilter;

    private long maxScanCount;

    private boolean withoutScalarData;

    private Object ext$;

    @Override
    public void write(CodedOutputStream out) {
        Writer.write(1, requestInfo, out);
        Writer.write(2, context, out);
        Writer.write(3, vectorIdStart, out);
        Writer.write(4, isReverseScan, out);
        Writer.write(5, maxScanCount, out);
        Writer.write(6, vectorIdEnd, out);
        Writer.write(10, ts, out);
        Writer.write(11, withoutVectorData, out);
        Writer.write(12, withoutScalarData, out);
        Writer.write(13, selectedKeys, (n, v) -> Writer.write(n, v, out));
        Writer.write(14, withoutTableData, out);
        Writer.write(20, useScalarFilter, out);
        Writer.write(21, scalarForFilter, out);
    }

    @Override
    public boolean read(CodedInputStream input) {
        int number = 0;
        boolean hasValue = false;
        while((number = Reader.readNumber(input)) != 0) {
            switch(number) {
                case 1: requestInfo = Reader.readMessage(new RequestInfo(), input); hasValue = hasValue ? hasValue : requestInfo != null; break;
                case 2: context = Reader.readMessage(new Context(), input); hasValue = hasValue ? hasValue : context != null; break;
                case 3: vectorIdStart = Reader.readLong(input); hasValue = true; break;
                case 4: isReverseScan = Reader.readBoolean(input); hasValue = true; break;
                case 5: maxScanCount = Reader.readLong(input); hasValue = true; break;
                case 6: vectorIdEnd = Reader.readLong(input); hasValue = true; break;
                case 10: ts = Reader.readLong(input); hasValue = true; break;
                case 11: withoutVectorData = Reader.readBoolean(input); hasValue = true; break;
                case 12: withoutScalarData = Reader.readBoolean(input); hasValue = true; break;
                case 13: selectedKeys = Reader.readList(selectedKeys, input, Reader::readString); hasValue = true; break;
                case 14: withoutTableData = Reader.readBoolean(input); hasValue = true; break;
                case 20: useScalarFilter = Reader.readBoolean(input); hasValue = true; break;
                case 21: scalarForFilter = Reader.readMessage(new VectorScalardata(), input); hasValue = hasValue ? hasValue : scalarForFilter != null; break;
                default: Reader.skip(input);
            }
        }
        return hasValue;
    }

    @Override
    public int sizeOf() {
        int size = 0;
        size += SizeUtils.sizeOf(1, requestInfo);
        size += SizeUtils.sizeOf(2, context);
        size += SizeUtils.sizeOf(3, vectorIdStart);
        size += SizeUtils.sizeOf(4, isReverseScan);
        size += SizeUtils.sizeOf(5, maxScanCount);
        size += SizeUtils.sizeOf(6, vectorIdEnd);
        size += SizeUtils.sizeOf(10, ts);
        size += SizeUtils.sizeOf(11, withoutVectorData);
        size += SizeUtils.sizeOf(12, withoutScalarData);
        size += SizeUtils.sizeOf(13, selectedKeys, SizeUtils::sizeOf);
        size += SizeUtils.sizeOf(14, withoutTableData);
        size += SizeUtils.sizeOf(20, useScalarFilter);
        size += SizeUtils.sizeOf(21, scalarForFilter);
        return size;
    }
}
