package io.dingodb.sdk.service.entity.index;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import io.dingodb.sdk.grpc.serializer.Reader;
import io.dingodb.sdk.grpc.serializer.SizeUtils;
import io.dingodb.sdk.grpc.serializer.Writer;
import io.dingodb.sdk.service.entity.Message;
import io.dingodb.sdk.service.entity.common.MetricType;
import io.dingodb.sdk.service.entity.common.RequestInfo;
import io.dingodb.sdk.service.entity.common.Vector;
import io.dingodb.sdk.service.entity.store.Context;
import java.util.List;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.FieldNameConstants;
import lombok.experimental.SuperBuilder;

@Data
@SuperBuilder
@NoArgsConstructor
@FieldNameConstants
public class VectorCalcDistanceRequest implements Message, Message.Request, Message.StoreRequest {
    private AlgorithmType algorithmType;

    private Context context;

    private List<Vector> opLeftVectors;

    private MetricType metricType;

    private RequestInfo requestInfo;

    private boolean isReturnNormlize;

    private List<Vector> opRightVectors;

    private Object ext$;

    @Override
    public void write(CodedOutputStream out) {
        Writer.write(1, requestInfo, out);
        Writer.write(2, algorithmType, out);
        Writer.write(3, metricType, out);
        Writer.write(4, opLeftVectors, (n, v) -> Writer.write(n, v, out));
        Writer.write(5, opRightVectors, (n, v) -> Writer.write(n, v, out));
        Writer.write(6, isReturnNormlize, out);
        Writer.write(10, context, out);
    }

    @Override
    public boolean read(CodedInputStream input) {
        int number = 0;
        boolean hasValue = false;
        while((number = Reader.readNumber(input)) != 0) {
            switch(number) {
                case 1: requestInfo = Reader.readMessage(new RequestInfo(), input); hasValue = hasValue ? hasValue : requestInfo != null; break;
                case 2: algorithmType = AlgorithmType.forNumber(Reader.readInt(input));hasValue = true; break;
                case 3: metricType = MetricType.forNumber(Reader.readInt(input));hasValue = true; break;
                case 4: opLeftVectors = Reader.readList(opLeftVectors, input, in -> Reader.readMessage(new Vector(), in)); hasValue = true; break;
                case 5: opRightVectors = Reader.readList(opRightVectors, input, in -> Reader.readMessage(new Vector(), in)); hasValue = true; break;
                case 6: isReturnNormlize = Reader.readBoolean(input); hasValue = true; break;
                case 10: context = Reader.readMessage(new Context(), input); hasValue = hasValue ? hasValue : context != null; break;
                default: Reader.skip(input);
            }
        }
        return hasValue;
    }

    @Override
    public int sizeOf() {
        int size = 0;
        size += SizeUtils.sizeOf(1, requestInfo);
        size += SizeUtils.sizeOf(2, algorithmType);
        size += SizeUtils.sizeOf(3, metricType);
        size += SizeUtils.sizeOf(4, opLeftVectors, SizeUtils::sizeOf);
        size += SizeUtils.sizeOf(5, opRightVectors, SizeUtils::sizeOf);
        size += SizeUtils.sizeOf(6, isReturnNormlize);
        size += SizeUtils.sizeOf(10, context);
        return size;
    }
}
