package io.dingodb.sdk.service.entity.index;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import io.dingodb.sdk.grpc.serializer.Reader;
import io.dingodb.sdk.grpc.serializer.SizeUtils;
import io.dingodb.sdk.grpc.serializer.Writer;
import io.dingodb.sdk.service.entity.Message;
import io.dingodb.sdk.service.entity.common.RequestInfo;
import io.dingodb.sdk.service.entity.store.Context;
import java.util.List;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.FieldNameConstants;
import lombok.experimental.SuperBuilder;

@Data
@SuperBuilder
@NoArgsConstructor
@FieldNameConstants
public class VectorBatchQueryRequest implements Message, Message.Request, Message.StoreRequest {
    private List<Long> vectorIds;

    private List<String> selectedKeys;

    private boolean withoutTableData;

    private Context context;

    private long ts;

    private boolean withoutVectorData;

    private RequestInfo requestInfo;

    private boolean withoutScalarData;

    private Object ext$;

    @Override
    public void write(CodedOutputStream out) {
        Writer.write(1, requestInfo, out);
        Writer.write(2, context, out);
        Writer.write(3, vectorIds, out, Writer::write, SizeUtils::sizeOf);
        Writer.write(4, withoutVectorData, out);
        Writer.write(5, withoutScalarData, out);
        Writer.write(6, selectedKeys, (n, v) -> Writer.write(n, v, out));
        Writer.write(7, withoutTableData, out);
        Writer.write(10, ts, out);
    }

    @Override
    public boolean read(CodedInputStream input) {
        int number = 0;
        boolean hasValue = false;
        while((number = Reader.readNumber(input)) != 0) {
            switch(number) {
                case 1: requestInfo = Reader.readMessage(new RequestInfo(), input); hasValue = hasValue ? hasValue : requestInfo != null; break;
                case 2: context = Reader.readMessage(new Context(), input); hasValue = hasValue ? hasValue : context != null; break;
                case 3: vectorIds = Reader.readPack(input, Reader::readLong); hasValue = true; break;
                case 4: withoutVectorData = Reader.readBoolean(input); hasValue = true; break;
                case 5: withoutScalarData = Reader.readBoolean(input); hasValue = true; break;
                case 6: selectedKeys = Reader.readList(selectedKeys, input, Reader::readString); hasValue = true; break;
                case 7: withoutTableData = Reader.readBoolean(input); hasValue = true; break;
                case 10: ts = Reader.readLong(input); hasValue = true; break;
                default: Reader.skip(input);
            }
        }
        return hasValue;
    }

    @Override
    public int sizeOf() {
        int size = 0;
        size += SizeUtils.sizeOf(1, requestInfo);
        size += SizeUtils.sizeOf(2, context);
        size += SizeUtils.sizeOfPack(3, vectorIds, SizeUtils::sizeOf);
        size += SizeUtils.sizeOf(4, withoutVectorData);
        size += SizeUtils.sizeOf(5, withoutScalarData);
        size += SizeUtils.sizeOf(6, selectedKeys, SizeUtils::sizeOf);
        size += SizeUtils.sizeOf(7, withoutTableData);
        size += SizeUtils.sizeOf(10, ts);
        return size;
    }
}
