package io.dingodb.sdk.service.entity.index;

import io.dingodb.sdk.service.entity.Numeric;

public enum AlgorithmType implements Numeric {
    UNRECOGNIZED(-1),

    ALGORITHM_NONE(0),

    ALGORITHM_FAISS(1),

    ALGORITHM_HNSWLIB(2);

    public final Integer number;

    private Object ext$;

    private AlgorithmType(Integer number) {
        this.number = number;
    }

    @Override
    public int number() {
        return number;
    }

    public static AlgorithmType forNumber(int number) {
        switch(number) {
            case -1: return UNRECOGNIZED;
            case 0: return ALGORITHM_NONE;
            case 1: return ALGORITHM_FAISS;
            case 2: return ALGORITHM_HNSWLIB;
            default: return null;
        }
    }
}
