package io.dingodb.sdk.service.entity.error;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import io.dingodb.sdk.grpc.serializer.Reader;
import io.dingodb.sdk.grpc.serializer.SizeUtils;
import io.dingodb.sdk.grpc.serializer.Writer;
import io.dingodb.sdk.service.entity.Message;
import io.dingodb.sdk.service.entity.common.Peer;
import io.dingodb.sdk.service.entity.common.Range;
import io.dingodb.sdk.service.entity.common.RegionEpoch;
import java.util.List;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.FieldNameConstants;
import lombok.experimental.SuperBuilder;

@Data
@SuperBuilder
@NoArgsConstructor
@FieldNameConstants
public class StoreRegionInfo implements Message {
    private Range currentRange;

    private RegionEpoch currentRegionEpoch;

    private List<Peer> peers;

    private long regionId;

    private Object ext$;

    @Override
    public void write(CodedOutputStream out) {
        Writer.write(1, regionId, out);
        Writer.write(2, currentRegionEpoch, out);
        Writer.write(3, currentRange, out);
        Writer.write(4, peers, (n, v) -> Writer.write(n, v, out));
    }

    @Override
    public boolean read(CodedInputStream input) {
        int number = 0;
        boolean hasValue = false;
        while((number = Reader.readNumber(input)) != 0) {
            switch(number) {
                case 1: regionId = Reader.readLong(input); hasValue = true; break;
                case 2: currentRegionEpoch = Reader.readMessage(new RegionEpoch(), input); hasValue = hasValue ? hasValue : currentRegionEpoch != null; break;
                case 3: currentRange = Reader.readMessage(new Range(), input); hasValue = hasValue ? hasValue : currentRange != null; break;
                case 4: peers = Reader.readList(peers, input, in -> Reader.readMessage(new Peer(), in)); hasValue = true; break;
                default: Reader.skip(input);
            }
        }
        return hasValue;
    }

    @Override
    public int sizeOf() {
        int size = 0;
        size += SizeUtils.sizeOf(1, regionId);
        size += SizeUtils.sizeOf(2, currentRegionEpoch);
        size += SizeUtils.sizeOf(3, currentRange);
        size += SizeUtils.sizeOf(4, peers, SizeUtils::sizeOf);
        return size;
    }
}
