package io.dingodb.sdk.service.entity.error;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import io.dingodb.sdk.grpc.serializer.Reader;
import io.dingodb.sdk.grpc.serializer.SizeUtils;
import io.dingodb.sdk.grpc.serializer.Writer;
import io.dingodb.sdk.service.entity.Message;
import io.dingodb.sdk.service.entity.common.Location;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.FieldNameConstants;
import lombok.experimental.SuperBuilder;

@Data
@SuperBuilder
@NoArgsConstructor
@FieldNameConstants
public class Error implements Message {
    private String errmsg;

    private Errno errcode;

    private StoreRegionInfo storeRegionInfo;

    private long storeId;

    private Location leaderLocation;

    private Object ext$;

    @Override
    public void write(CodedOutputStream out) {
        Writer.write(1, errcode, out);
        Writer.write(2, errmsg, out);
        Writer.write(3, leaderLocation, out);
        Writer.write(4, storeRegionInfo, out);
        Writer.write(5, storeId, out);
    }

    @Override
    public boolean read(CodedInputStream input) {
        int number = 0;
        boolean hasValue = false;
        while((number = Reader.readNumber(input)) != 0) {
            switch(number) {
                case 1: errcode = Errno.forNumber(Reader.readInt(input));hasValue = true; break;
                case 2: errmsg = Reader.readString(input); hasValue = true; break;
                case 3: leaderLocation = Reader.readMessage(new Location(), input); hasValue = hasValue ? hasValue : leaderLocation != null; break;
                case 4: storeRegionInfo = Reader.readMessage(new StoreRegionInfo(), input); hasValue = hasValue ? hasValue : storeRegionInfo != null; break;
                case 5: storeId = Reader.readLong(input); hasValue = true; break;
                default: Reader.skip(input);
            }
        }
        return hasValue;
    }

    @Override
    public int sizeOf() {
        int size = 0;
        size += SizeUtils.sizeOf(1, errcode);
        size += SizeUtils.sizeOf(2, errmsg);
        size += SizeUtils.sizeOf(3, leaderLocation);
        size += SizeUtils.sizeOf(4, storeRegionInfo);
        size += SizeUtils.sizeOf(5, storeId);
        return size;
    }
}
