package io.dingodb.sdk.service.entity.error;

import io.dingodb.sdk.service.entity.Numeric;

public enum Errno implements Numeric {
    UNRECOGNIZED(-1),

    OK(0),

    EBRAFT_EPERM(1),

    EBRAFT_ENOENT(2),

    EBRAFT_ESRCH(3),

    EBRAFT_EINTR(4),

    EBRAFT_EIO(5),

    EBRAFT_ENXIO(6),

    EBRAFT_E2BIG(7),

    EBRAFT_ENOEXEC(8),

    EBRAFT_EBADF(9),

    EBRAFT_ECHILD(10),

    EBRAFT_EAGAIN(11),

    EBRAFT_ENOMEM(12),

    EBRAFT_EACCES(13),

    EBRAFT_EFAULT(14),

    EBRAFT_ENOTBLK(15),

    EBRAFT_EBUSY(16),

    EBRAFT_EEXIST(17),

    EBRAFT_EXDEV(18),

    EBRAFT_ENODEV(19),

    EBRAFT_ENOTDIR(20),

    EBRAFT_EISDIR(21),

    EBRAFT_EINVAL(22),

    EBRAFT_ENFILE(23),

    EBRAFT_EMFILE(24),

    EBRAFT_ENOTTY(25),

    EBRAFT_ETXTBSY(26),

    EBRAFT_EFBIG(27),

    EBRAFT_ENOSPC(28),

    EBRAFT_ESPIPE(29),

    EBRAFT_EROFS(30),

    EBRAFT_EMLINK(31),

    EBRAFT_EPIPE(32),

    EBRAFT_EDOM(33),

    EBRAFT_ERANGE(34),

    EINTERNAL(10000),

    ENO_ENTRIES(10002),

    EILLEGAL_PARAMTETERS(10010),

    EKEY_NOT_FOUND(10011),

    EKEY_FORMAT(10012),

    EKEY_EMPTY(10013),

    EKEY_EXIST(10014),

    ENOT_SUPPORT(10100),

    EKEY_OUT_OF_RANGE(10101),

    EKEY_INVALID(10102),

    EFAIL_POINT(10103),

    EFAIL_POINT_RETURN(10104),

    ERANGE_INVALID(10105),

    ESCAN_NOTFOUND(10106),

    EENGINE_NOT_FOUND(10107),

    ERAW_ENGINE_NOT_FOUND(10108),

    EREQUEST_EMPTY(10109),

    EREQUEST_FULL(10110),

    EVALUE_EMPTY(10111),

    EJOB_ID_EMPTY(10112),

    ETHREADPOOL_NOTFOUND(10113),

    EBIND_CORE(10114),

    EUNBIND_CORE(10115),

    ETSO_NOT_AVAILABLE(10116),

    ENOT_IMPLEMENTED(10117),

    ESTREAM_EXPIRED(10118),

    ESCHEMA_EXISTS(30000),

    ESCHEMA_NOT_FOUND(30001),

    ESCHEMA_NOT_EMPTY(30002),

    ETABLE_EXISTS(30003),

    ETABLE_NOT_FOUND(30004),

    ETABLE_DEFINITION_ILLEGAL(30005),

    ETABLE_REGION_CREATE_FAILED(30006),

    ETABLE_REGION_DROP_FAILED(30007),

    ETABLE_METRICS_FAILED(30008),

    EINDEX_EXISTS(30009),

    EINDEX_NOT_FOUND(30010),

    EINDEX_DEFINITION_ILLEGAL(30011),

    EINDEX_REGION_CREATE_FAILED(30012),

    EINDEX_REGION_DROP_FAILED(30013),

    EINDEX_METRICS_FAILED(30014),

    EINDEX_COMPATIBILITY(30015),

    EINDEX_COLUMN_NOT_FOUND(30016),

    ETABLE_COUNT_EXCEED_LIMIT(30017),

    EINDEX_COUNT_EXCEED_LIMIT(30018),

    EREGION_COUNT_EXCEED_LIMIT(30019),

    EREGION_RANGE_CONFLICT(30020),

    EAUTO_INCREMENT_WHILE_CREATING_TABLE(30101),

    EAUTO_INCREMENT_EXIST(30102),

    EAUTO_INCREMENT_NOT_FOUND(30103),

    ELEASE_NOT_EXISTS_OR_EXPIRED(30201),

    ESPLIT_STATUS_ILLEGAL(40000),

    ESPLIT_PEER_NOT_MATCH(40001),

    EMERGE_STATUS_ILLEGAL(40002),

    EMERGE_PEER_NOT_MATCH(40003),

    EMERGE_RANGE_NOT_MATCH(40004),

    ECHANGE_PEER_STATUS_ILLEGAL(40005),

    ESTORE_NOT_FOUND(40007),

    EREGION_CMD_ONGOING_CONFLICT(40008),

    ESTORE_IN_USE(40009),

    EKEYRING_ILLEGAL(40010),

    EEXECUTOR_NOT_FOUND(40011),

    EUSER_ALREADY_EXIST(40012),

    EUSER_NOT_EXIST(40013),

    ECHANGE_PEER_UNABLE_TO_REMOVE_LEADER(40015),

    ETASK_LIST_CONFLICT(40016),

    ESTORE_OPERATION_CONFLICT(40017),

    ERETRY_LATER(40018),

    EEXEC_FAIL(40019),

    EPARSE_FROM_PB_FAIL(40020),

    EUNSUPPORT_REQ_TYPE(40021),

    EREGION_CMD_NOT_FOUND(40022),

    ESEND_STORE_OPERATION_FAIL(40023),

    EMERGE_PART_NOT_MATCH(40024),

    ELEASE_COUNT_EXCEEDS_LIMIT(40025),

    EWATCH_COUNT_EXCEEDS_LIMIT(40026),

    EKV_COUNT_EXCEEDS_LIMIT(40027),

    EKV_REV_COUNT_EXCEEDS_LIMIT(40028),

    EMERGE_REGION_TYPE_NOT_MATCH(40029),

    EMERGE_VECTOR_INDEX_TYPE_NOT_MATCH(40030),

    EMERGE_VECTOR_INDEX_PARAMETER_NOT_MATCH(40031),

    EWATCH_EXIST(40032),

    EWATCH_NOT_EXIST(40033),

    EMERGE_STORE_ENGINE_NOT_MATCH(40034),

    EMERGE_RAW_ENGINE_NOT_MATCH(40035),

    ECHANGE_PEER_STORE_ENGINE_NOT_MATCH(40036),

    ERAFT_INIT(50000),

    ERAFT_NOT_FOUND(50001),

    ERAFT_NOTLEADER(50002),

    ERAFT_COMMITLOG(50003),

    ERAFT_SAVE_SNAPSHOT(50010),

    ERAFT_LOAD_SNAPSHOT(50011),

    ERAFT_TRANSFER_LEADER(50012),

    ERAFT_NOT_FOLLOWER(50013),

    ERAFT_NOT_FOUND_LOG_STORAGE(50014),

    ERAFT_EXIST_CHANGE_LOG(50015),

    ERAFT_DISABLE_SAVE_SNAPSHOT(50016),

    ERAFT_NOT_NEED_SNAPSHOT(50017),

    ERAFT_META_NOT_FOUND(50018),

    ERAFT_LOG_NOT_FOUND(50019),

    EREGION_EXIST(60000),

    EREGION_NOT_FOUND(60001),

    EREGION_UNAVAILABLE(60002),

    EREGION_STATE(60003),

    EREGION_REPEAT_COMMAND(60004),

    EREGION_DELETING(60005),

    EREGION_SPLITING(60006),

    EREGION_MERGEING(60007),

    EREGION_PEER_CHANGEING(60008),

    EREGION_REDIRECT(60009),

    EREGION_VERSION(60010),

    EREGION_DISABLE_CHANGE(60011),

    EREGION_SNAPSHOT_EPOCH_NOT_MATCH(60012),

    EREGION_NOT_NEIGHBOR(60013),

    EREGION_EMPTY_ID(60014),

    EREGION_DELETED(60015),

    EREGION_BUSY(60016),

    EREGION_DISABLE_SPLIT(60017),

    EREGION_DISABLE_MERGE(60018),

    EREGION_NEW(60019),

    EREGION_STANDBY(60020),

    EREGION_ORPHAN(60021),

    EREGION_TOMBSTONE(60022),

    EVECTOR_INDEX_NOT_FOUND(70000),

    EVECTOR_NOT_SUPPORT(70001),

    EVECTOR_NOT_SUPPORT_DIMENSION(70002),

    EVECTOR_NOT_SUPPORT_INDEX_TYPE(70003),

    EVECTOR_EMPTY(70004),

    EVECTOR_INVALID(70005),

    EVECTOR_INDEX_OFFLINE(70006),

    EVECTOR_SCALAR_DATA_NOT_FOUND(70007),

    EVECTOR_SNAPSHOT_NOT_FOUND(70008),

    EVECTOR_SNAPSHOT_INVALID(70009),

    EVECTOR_INDEX_EXCEED_MAX_ELEMENTS(70010),

    EVECTOR_NOT_FOUND(70011),

    EVECTOR_INDEX_FULL(70012),

    EVECTOR_EXCEED_MAX_BATCH_COUNT(70013),

    EVECTOR_EXCEED_MAX_REQUEST_SIZE(70014),

    EVECTOR_SNAPSHOT_EXIST(70015),

    EVECTOR_NOT_NEED_SNAPSHOT(70016),

    EVECTOR_INDEX_EXIST(70017),

    EVECTOR_INDEX_SWITCHING(70018),

    EVECTOR_INDEX_NOT_READY(70019),

    EVECTOR_NOT_TRAIN(70020),

    EVECTOR_INDEX_BUILD_ERROR(70021),

    EVECTOR_INDEX_SAVE_SUCCESS(70022),

    EVECTOR_INDEX_BUILD_CONFLICT(70023),

    EVECTOR_INDEX_REBUILD_CONFLICT(70024),

    EVECTOR_INDEX_MERGE_RESULT(70025),

    EVECTOR_INDEX_LOAD_SNAPSHOT(70026),

    EVECTOR_INDEX_SNAPSHOT_VERSION_NOT_MATCH(70027),

    EVECTOR_ID_DUPLICATED(70028),

    EDISKANN_IS_BUILDING(70900),

    EDISKANN_IS_LOADING(70901),

    EDISKANN_NOT_BUILD(70902),

    EDISKANN_NOT_LOAD(70903),

    EDISKANN_NOT_UPDATE(70904),

    EDISKANN_NOT_INIT(70905),

    EDISKANN_ALREADY_IMPORT(70906),

    EDISKANN_FILE_TRANSFER_QUANTITY_MISMATCH(70907),

    EDISKANN_IMPORT_FAILED(70908),

    EDISKANN_NOT_IMPORT(70909),

    EDISKANN_IMPORT_COUNT_TOO_FEW(70910),

    EDISKANN_IMPORT_COUNT_TOO_MANY(70911),

    EDISKANN_IMPORT_VECTOR_ID_DUPLICATED(70912),

    EDISKANN_IMPORT_VECTOR_ID_COUNT_NOT_MATCH(70913),

    EDISKANN_ID_BIN_DIMENSION_NOT_MATCH(70914),

    EDISKANN_ID_BIN_COUNT_NOT_MATCH(70915),

    EDISKANN_ID_BIN_READ_ERROR(70916),

    EDISKANN_IMPORT_TS_NOT_MATCH(70917),

    EDISKANN_IMPORT_TSO_NOT_MATCH(70918),

    EDISKANN_IMPORT_TIMEOUT(70919),

    EDISKANN_IS_IMPORTING(70920),

    EDISKANN_STATE_WRONG(70921),

    EDISKANN_IMPORT_STATE_WRONG(70922),

    EDISKANN_BUILD_STATE_WRONG(70923),

    EDISKANN_LOAD_STATE_WRONG(70924),

    EDISKANN_TRYLOAD_STATE_WRONG(70925),

    EDISKANN_NET_DISCONNECTED(70926),

    EDISKANN_SEARCH_STATE_WRONG(70927),

    EDISKANN_IS_NO_DATA(70928),

    EDISKANN_NO_DATA_STATE_WRONG(70929),

    EDISKANN_AIO_NOT_ENOUGH(70930),

    EDOCUMENT_INDEX_NOT_FOUND(71000),

    EDOCUMENT_NOT_SUPPORT(71001),

    EDOCUMENT_NOT_SUPPORT_DIMENSION(71002),

    EDOCUMENT_NOT_SUPPORT_INDEX_TYPE(71003),

    EDOCUMENT_EMPTY(71004),

    EDOCUMENT_INVALID(71005),

    EDOCUMENT_INDEX_OFFLINE(71006),

    EDOCUMENT_SCALAR_DATA_NOT_FOUND(71007),

    EDOCUMENT_SNAPSHOT_NOT_FOUND(71008),

    EDOCUMENT_SNAPSHOT_INVALID(71009),

    EDOCUMENT_INDEX_EXCEED_MAX_ELEMENTS(71010),

    EDOCUMENT_NOT_FOUND(71011),

    EDOCUMENT_INDEX_FULL(71012),

    EDOCUMENT_EXCEED_MAX_BATCH_COUNT(71013),

    EDOCUMENT_EXCEED_MAX_REQUEST_SIZE(71014),

    EDOCUMENT_SNAPSHOT_EXIST(71015),

    EDOCUMENT_NOT_NEED_SNAPSHOT(71016),

    EDOCUMENT_INDEX_EXIST(71017),

    EDOCUMENT_INDEX_SWITCHING(71018),

    EDOCUMENT_INDEX_NOT_READY(71019),

    EDOCUMENT_NOT_TRAIN(71020),

    EDOCUMENT_INDEX_BUILD_ERROR(71021),

    EDOCUMENT_INDEX_SAVE_SUCCESS(71022),

    EDOCUMENT_INDEX_BUILD_CONFLICT(71023),

    EDOCUMENT_INDEX_REBUILD_CONFLICT(71024),

    EDOCUMENT_INDEX_MERGE_RESULT(71025),

    EDOCUMENT_INDEX_LOAD_SNAPSHOT(71026),

    EDOCUMENT_INDEX_SNAPSHOT_VERSION_NOT_MATCH(71027),

    EFILE_NOT_FOUND_READER(80000),

    EFILE_READ(80001),

    EFILE_NOT_EXIST(80002),

    EFILE_NOT_REGULAR(80003),

    EFILE_NOT_DIRECTORY(80004),

    EFILE_IS_DIRECTORY(80005),

    EFILE_NOT_OWNER_READABLE(80006),

    EFILE_PERMISSION_DENIED(80007),

    EFILE_CROSS_DEVICE(80008),

    EFILE_EXIST(80009),

    ESYSTEM_DISK_CAPACITY_FULL(90000),

    ESYSTEM_MEMORY_CAPACITY_FULL(90001),

    ESYSTEM_CLUSTER_READ_ONLY(90002),

    EBDB_EXCEPTION(120000),

    ESTD_EXCEPTION(120001),

    EBDB_DEADLOCK(120002),

    EBDB_COMMIT(120003),

    EBDB_UNKNOW(120004),

    EBDB_UNSUPPORTED(120005),

    ETXN_RESULT_INFO_NOT_NULL(130000),

    ETXN_SCAN_FINISH(130001),

    ETXN_LOCK_CONFLICT(130002),

    EROCKS_ENGINE_UPDATE(140000),

    ESTORAGE_NOT_FOUND(140001),

    EBACKUP_TASK_EXIST(150000),

    EBACKUP_TASK_NAME_NOT_MATCH(150001),

    EBACKUP_TXN_FOUND_LOCK(150002),

    EBACKUP_CREATE_REMOTE_DIR(150003),

    EBACKUP_VERSION_NOT_MATCH(150004),

    ERESTORE_VERSION_NOT_MATCH(150005),

    ERESTORE_FILE_CHECKSUM_NOT_MATCH(150006),

    ERESTORE_DINGO_STORE_NOT_EMPTY(150007),

    ERESTORE_NOT_FOUND_KEY_IN_FILE(150008),

    ERESTORE_DINGO_STORE_IS_BACKING_UP(150009),

    ERESTORE_FIELD_NOT_MATCH(150010),

    ERESTORE_TASK_EXIST(150011),

    ERESTORE_TASK_NAME_NOT_MATCH(150012),

    ERESTORE_REGION_ID_NOT_MATCH(150013),

    ERESTORE_REGION_META_NOT_FOUND(150014),

    ERESTORE_BACKEND_NOT_SUPPORT(150015),

    ERESTORE_CF_NOT_MATCH(150016),

    ERESTORE_CF_NOT_EXIST(150017),

    ERESTORE_PARSE_FILE_NAME_FAILED(150018),

    EBACKUP_DINGO_STORE_JOB_LIST_EXIST(150019),

    ERESTORE_STORE_NODE_NOT_EXIST(150020),

    ERESTORE_INDEX_NODE_NOT_EXIST(150021),

    ERESTORE_DOCUMENT_NODE_NOT_EXIST(150022);

    public final Integer number;

    private Object ext$;

    private Errno(Integer number) {
        this.number = number;
    }

    @Override
    public int number() {
        return number;
    }

    public static Errno forNumber(int number) {
        switch(number) {
            case -1: return UNRECOGNIZED;
            case 0: return OK;
            case 1: return EBRAFT_EPERM;
            case 2: return EBRAFT_ENOENT;
            case 3: return EBRAFT_ESRCH;
            case 4: return EBRAFT_EINTR;
            case 5: return EBRAFT_EIO;
            case 6: return EBRAFT_ENXIO;
            case 7: return EBRAFT_E2BIG;
            case 8: return EBRAFT_ENOEXEC;
            case 9: return EBRAFT_EBADF;
            case 10: return EBRAFT_ECHILD;
            case 11: return EBRAFT_EAGAIN;
            case 12: return EBRAFT_ENOMEM;
            case 13: return EBRAFT_EACCES;
            case 14: return EBRAFT_EFAULT;
            case 15: return EBRAFT_ENOTBLK;
            case 16: return EBRAFT_EBUSY;
            case 17: return EBRAFT_EEXIST;
            case 18: return EBRAFT_EXDEV;
            case 19: return EBRAFT_ENODEV;
            case 20: return EBRAFT_ENOTDIR;
            case 21: return EBRAFT_EISDIR;
            case 22: return EBRAFT_EINVAL;
            case 23: return EBRAFT_ENFILE;
            case 24: return EBRAFT_EMFILE;
            case 25: return EBRAFT_ENOTTY;
            case 26: return EBRAFT_ETXTBSY;
            case 27: return EBRAFT_EFBIG;
            case 28: return EBRAFT_ENOSPC;
            case 29: return EBRAFT_ESPIPE;
            case 30: return EBRAFT_EROFS;
            case 31: return EBRAFT_EMLINK;
            case 32: return EBRAFT_EPIPE;
            case 33: return EBRAFT_EDOM;
            case 34: return EBRAFT_ERANGE;
            case 10000: return EINTERNAL;
            case 10002: return ENO_ENTRIES;
            case 10010: return EILLEGAL_PARAMTETERS;
            case 10011: return EKEY_NOT_FOUND;
            case 10012: return EKEY_FORMAT;
            case 10013: return EKEY_EMPTY;
            case 10014: return EKEY_EXIST;
            case 10100: return ENOT_SUPPORT;
            case 10101: return EKEY_OUT_OF_RANGE;
            case 10102: return EKEY_INVALID;
            case 10103: return EFAIL_POINT;
            case 10104: return EFAIL_POINT_RETURN;
            case 10105: return ERANGE_INVALID;
            case 10106: return ESCAN_NOTFOUND;
            case 10107: return EENGINE_NOT_FOUND;
            case 10108: return ERAW_ENGINE_NOT_FOUND;
            case 10109: return EREQUEST_EMPTY;
            case 10110: return EREQUEST_FULL;
            case 10111: return EVALUE_EMPTY;
            case 10112: return EJOB_ID_EMPTY;
            case 10113: return ETHREADPOOL_NOTFOUND;
            case 10114: return EBIND_CORE;
            case 10115: return EUNBIND_CORE;
            case 10116: return ETSO_NOT_AVAILABLE;
            case 10117: return ENOT_IMPLEMENTED;
            case 10118: return ESTREAM_EXPIRED;
            case 30000: return ESCHEMA_EXISTS;
            case 30001: return ESCHEMA_NOT_FOUND;
            case 30002: return ESCHEMA_NOT_EMPTY;
            case 30003: return ETABLE_EXISTS;
            case 30004: return ETABLE_NOT_FOUND;
            case 30005: return ETABLE_DEFINITION_ILLEGAL;
            case 30006: return ETABLE_REGION_CREATE_FAILED;
            case 30007: return ETABLE_REGION_DROP_FAILED;
            case 30008: return ETABLE_METRICS_FAILED;
            case 30009: return EINDEX_EXISTS;
            case 30010: return EINDEX_NOT_FOUND;
            case 30011: return EINDEX_DEFINITION_ILLEGAL;
            case 30012: return EINDEX_REGION_CREATE_FAILED;
            case 30013: return EINDEX_REGION_DROP_FAILED;
            case 30014: return EINDEX_METRICS_FAILED;
            case 30015: return EINDEX_COMPATIBILITY;
            case 30016: return EINDEX_COLUMN_NOT_FOUND;
            case 30017: return ETABLE_COUNT_EXCEED_LIMIT;
            case 30018: return EINDEX_COUNT_EXCEED_LIMIT;
            case 30019: return EREGION_COUNT_EXCEED_LIMIT;
            case 30020: return EREGION_RANGE_CONFLICT;
            case 30101: return EAUTO_INCREMENT_WHILE_CREATING_TABLE;
            case 30102: return EAUTO_INCREMENT_EXIST;
            case 30103: return EAUTO_INCREMENT_NOT_FOUND;
            case 30201: return ELEASE_NOT_EXISTS_OR_EXPIRED;
            case 40000: return ESPLIT_STATUS_ILLEGAL;
            case 40001: return ESPLIT_PEER_NOT_MATCH;
            case 40002: return EMERGE_STATUS_ILLEGAL;
            case 40003: return EMERGE_PEER_NOT_MATCH;
            case 40004: return EMERGE_RANGE_NOT_MATCH;
            case 40005: return ECHANGE_PEER_STATUS_ILLEGAL;
            case 40007: return ESTORE_NOT_FOUND;
            case 40008: return EREGION_CMD_ONGOING_CONFLICT;
            case 40009: return ESTORE_IN_USE;
            case 40010: return EKEYRING_ILLEGAL;
            case 40011: return EEXECUTOR_NOT_FOUND;
            case 40012: return EUSER_ALREADY_EXIST;
            case 40013: return EUSER_NOT_EXIST;
            case 40015: return ECHANGE_PEER_UNABLE_TO_REMOVE_LEADER;
            case 40016: return ETASK_LIST_CONFLICT;
            case 40017: return ESTORE_OPERATION_CONFLICT;
            case 40018: return ERETRY_LATER;
            case 40019: return EEXEC_FAIL;
            case 40020: return EPARSE_FROM_PB_FAIL;
            case 40021: return EUNSUPPORT_REQ_TYPE;
            case 40022: return EREGION_CMD_NOT_FOUND;
            case 40023: return ESEND_STORE_OPERATION_FAIL;
            case 40024: return EMERGE_PART_NOT_MATCH;
            case 40025: return ELEASE_COUNT_EXCEEDS_LIMIT;
            case 40026: return EWATCH_COUNT_EXCEEDS_LIMIT;
            case 40027: return EKV_COUNT_EXCEEDS_LIMIT;
            case 40028: return EKV_REV_COUNT_EXCEEDS_LIMIT;
            case 40029: return EMERGE_REGION_TYPE_NOT_MATCH;
            case 40030: return EMERGE_VECTOR_INDEX_TYPE_NOT_MATCH;
            case 40031: return EMERGE_VECTOR_INDEX_PARAMETER_NOT_MATCH;
            case 40032: return EWATCH_EXIST;
            case 40033: return EWATCH_NOT_EXIST;
            case 40034: return EMERGE_STORE_ENGINE_NOT_MATCH;
            case 40035: return EMERGE_RAW_ENGINE_NOT_MATCH;
            case 40036: return ECHANGE_PEER_STORE_ENGINE_NOT_MATCH;
            case 50000: return ERAFT_INIT;
            case 50001: return ERAFT_NOT_FOUND;
            case 50002: return ERAFT_NOTLEADER;
            case 50003: return ERAFT_COMMITLOG;
            case 50010: return ERAFT_SAVE_SNAPSHOT;
            case 50011: return ERAFT_LOAD_SNAPSHOT;
            case 50012: return ERAFT_TRANSFER_LEADER;
            case 50013: return ERAFT_NOT_FOLLOWER;
            case 50014: return ERAFT_NOT_FOUND_LOG_STORAGE;
            case 50015: return ERAFT_EXIST_CHANGE_LOG;
            case 50016: return ERAFT_DISABLE_SAVE_SNAPSHOT;
            case 50017: return ERAFT_NOT_NEED_SNAPSHOT;
            case 50018: return ERAFT_META_NOT_FOUND;
            case 50019: return ERAFT_LOG_NOT_FOUND;
            case 60000: return EREGION_EXIST;
            case 60001: return EREGION_NOT_FOUND;
            case 60002: return EREGION_UNAVAILABLE;
            case 60003: return EREGION_STATE;
            case 60004: return EREGION_REPEAT_COMMAND;
            case 60005: return EREGION_DELETING;
            case 60006: return EREGION_SPLITING;
            case 60007: return EREGION_MERGEING;
            case 60008: return EREGION_PEER_CHANGEING;
            case 60009: return EREGION_REDIRECT;
            case 60010: return EREGION_VERSION;
            case 60011: return EREGION_DISABLE_CHANGE;
            case 60012: return EREGION_SNAPSHOT_EPOCH_NOT_MATCH;
            case 60013: return EREGION_NOT_NEIGHBOR;
            case 60014: return EREGION_EMPTY_ID;
            case 60015: return EREGION_DELETED;
            case 60016: return EREGION_BUSY;
            case 60017: return EREGION_DISABLE_SPLIT;
            case 60018: return EREGION_DISABLE_MERGE;
            case 60019: return EREGION_NEW;
            case 60020: return EREGION_STANDBY;
            case 60021: return EREGION_ORPHAN;
            case 60022: return EREGION_TOMBSTONE;
            case 70000: return EVECTOR_INDEX_NOT_FOUND;
            case 70001: return EVECTOR_NOT_SUPPORT;
            case 70002: return EVECTOR_NOT_SUPPORT_DIMENSION;
            case 70003: return EVECTOR_NOT_SUPPORT_INDEX_TYPE;
            case 70004: return EVECTOR_EMPTY;
            case 70005: return EVECTOR_INVALID;
            case 70006: return EVECTOR_INDEX_OFFLINE;
            case 70007: return EVECTOR_SCALAR_DATA_NOT_FOUND;
            case 70008: return EVECTOR_SNAPSHOT_NOT_FOUND;
            case 70009: return EVECTOR_SNAPSHOT_INVALID;
            case 70010: return EVECTOR_INDEX_EXCEED_MAX_ELEMENTS;
            case 70011: return EVECTOR_NOT_FOUND;
            case 70012: return EVECTOR_INDEX_FULL;
            case 70013: return EVECTOR_EXCEED_MAX_BATCH_COUNT;
            case 70014: return EVECTOR_EXCEED_MAX_REQUEST_SIZE;
            case 70015: return EVECTOR_SNAPSHOT_EXIST;
            case 70016: return EVECTOR_NOT_NEED_SNAPSHOT;
            case 70017: return EVECTOR_INDEX_EXIST;
            case 70018: return EVECTOR_INDEX_SWITCHING;
            case 70019: return EVECTOR_INDEX_NOT_READY;
            case 70020: return EVECTOR_NOT_TRAIN;
            case 70021: return EVECTOR_INDEX_BUILD_ERROR;
            case 70022: return EVECTOR_INDEX_SAVE_SUCCESS;
            case 70023: return EVECTOR_INDEX_BUILD_CONFLICT;
            case 70024: return EVECTOR_INDEX_REBUILD_CONFLICT;
            case 70025: return EVECTOR_INDEX_MERGE_RESULT;
            case 70026: return EVECTOR_INDEX_LOAD_SNAPSHOT;
            case 70027: return EVECTOR_INDEX_SNAPSHOT_VERSION_NOT_MATCH;
            case 70028: return EVECTOR_ID_DUPLICATED;
            case 70900: return EDISKANN_IS_BUILDING;
            case 70901: return EDISKANN_IS_LOADING;
            case 70902: return EDISKANN_NOT_BUILD;
            case 70903: return EDISKANN_NOT_LOAD;
            case 70904: return EDISKANN_NOT_UPDATE;
            case 70905: return EDISKANN_NOT_INIT;
            case 70906: return EDISKANN_ALREADY_IMPORT;
            case 70907: return EDISKANN_FILE_TRANSFER_QUANTITY_MISMATCH;
            case 70908: return EDISKANN_IMPORT_FAILED;
            case 70909: return EDISKANN_NOT_IMPORT;
            case 70910: return EDISKANN_IMPORT_COUNT_TOO_FEW;
            case 70911: return EDISKANN_IMPORT_COUNT_TOO_MANY;
            case 70912: return EDISKANN_IMPORT_VECTOR_ID_DUPLICATED;
            case 70913: return EDISKANN_IMPORT_VECTOR_ID_COUNT_NOT_MATCH;
            case 70914: return EDISKANN_ID_BIN_DIMENSION_NOT_MATCH;
            case 70915: return EDISKANN_ID_BIN_COUNT_NOT_MATCH;
            case 70916: return EDISKANN_ID_BIN_READ_ERROR;
            case 70917: return EDISKANN_IMPORT_TS_NOT_MATCH;
            case 70918: return EDISKANN_IMPORT_TSO_NOT_MATCH;
            case 70919: return EDISKANN_IMPORT_TIMEOUT;
            case 70920: return EDISKANN_IS_IMPORTING;
            case 70921: return EDISKANN_STATE_WRONG;
            case 70922: return EDISKANN_IMPORT_STATE_WRONG;
            case 70923: return EDISKANN_BUILD_STATE_WRONG;
            case 70924: return EDISKANN_LOAD_STATE_WRONG;
            case 70925: return EDISKANN_TRYLOAD_STATE_WRONG;
            case 70926: return EDISKANN_NET_DISCONNECTED;
            case 70927: return EDISKANN_SEARCH_STATE_WRONG;
            case 70928: return EDISKANN_IS_NO_DATA;
            case 70929: return EDISKANN_NO_DATA_STATE_WRONG;
            case 70930: return EDISKANN_AIO_NOT_ENOUGH;
            case 71000: return EDOCUMENT_INDEX_NOT_FOUND;
            case 71001: return EDOCUMENT_NOT_SUPPORT;
            case 71002: return EDOCUMENT_NOT_SUPPORT_DIMENSION;
            case 71003: return EDOCUMENT_NOT_SUPPORT_INDEX_TYPE;
            case 71004: return EDOCUMENT_EMPTY;
            case 71005: return EDOCUMENT_INVALID;
            case 71006: return EDOCUMENT_INDEX_OFFLINE;
            case 71007: return EDOCUMENT_SCALAR_DATA_NOT_FOUND;
            case 71008: return EDOCUMENT_SNAPSHOT_NOT_FOUND;
            case 71009: return EDOCUMENT_SNAPSHOT_INVALID;
            case 71010: return EDOCUMENT_INDEX_EXCEED_MAX_ELEMENTS;
            case 71011: return EDOCUMENT_NOT_FOUND;
            case 71012: return EDOCUMENT_INDEX_FULL;
            case 71013: return EDOCUMENT_EXCEED_MAX_BATCH_COUNT;
            case 71014: return EDOCUMENT_EXCEED_MAX_REQUEST_SIZE;
            case 71015: return EDOCUMENT_SNAPSHOT_EXIST;
            case 71016: return EDOCUMENT_NOT_NEED_SNAPSHOT;
            case 71017: return EDOCUMENT_INDEX_EXIST;
            case 71018: return EDOCUMENT_INDEX_SWITCHING;
            case 71019: return EDOCUMENT_INDEX_NOT_READY;
            case 71020: return EDOCUMENT_NOT_TRAIN;
            case 71021: return EDOCUMENT_INDEX_BUILD_ERROR;
            case 71022: return EDOCUMENT_INDEX_SAVE_SUCCESS;
            case 71023: return EDOCUMENT_INDEX_BUILD_CONFLICT;
            case 71024: return EDOCUMENT_INDEX_REBUILD_CONFLICT;
            case 71025: return EDOCUMENT_INDEX_MERGE_RESULT;
            case 71026: return EDOCUMENT_INDEX_LOAD_SNAPSHOT;
            case 71027: return EDOCUMENT_INDEX_SNAPSHOT_VERSION_NOT_MATCH;
            case 80000: return EFILE_NOT_FOUND_READER;
            case 80001: return EFILE_READ;
            case 80002: return EFILE_NOT_EXIST;
            case 80003: return EFILE_NOT_REGULAR;
            case 80004: return EFILE_NOT_DIRECTORY;
            case 80005: return EFILE_IS_DIRECTORY;
            case 80006: return EFILE_NOT_OWNER_READABLE;
            case 80007: return EFILE_PERMISSION_DENIED;
            case 80008: return EFILE_CROSS_DEVICE;
            case 80009: return EFILE_EXIST;
            case 90000: return ESYSTEM_DISK_CAPACITY_FULL;
            case 90001: return ESYSTEM_MEMORY_CAPACITY_FULL;
            case 90002: return ESYSTEM_CLUSTER_READ_ONLY;
            case 120000: return EBDB_EXCEPTION;
            case 120001: return ESTD_EXCEPTION;
            case 120002: return EBDB_DEADLOCK;
            case 120003: return EBDB_COMMIT;
            case 120004: return EBDB_UNKNOW;
            case 120005: return EBDB_UNSUPPORTED;
            case 130000: return ETXN_RESULT_INFO_NOT_NULL;
            case 130001: return ETXN_SCAN_FINISH;
            case 130002: return ETXN_LOCK_CONFLICT;
            case 140000: return EROCKS_ENGINE_UPDATE;
            case 140001: return ESTORAGE_NOT_FOUND;
            case 150000: return EBACKUP_TASK_EXIST;
            case 150001: return EBACKUP_TASK_NAME_NOT_MATCH;
            case 150002: return EBACKUP_TXN_FOUND_LOCK;
            case 150003: return EBACKUP_CREATE_REMOTE_DIR;
            case 150004: return EBACKUP_VERSION_NOT_MATCH;
            case 150005: return ERESTORE_VERSION_NOT_MATCH;
            case 150006: return ERESTORE_FILE_CHECKSUM_NOT_MATCH;
            case 150007: return ERESTORE_DINGO_STORE_NOT_EMPTY;
            case 150008: return ERESTORE_NOT_FOUND_KEY_IN_FILE;
            case 150009: return ERESTORE_DINGO_STORE_IS_BACKING_UP;
            case 150010: return ERESTORE_FIELD_NOT_MATCH;
            case 150011: return ERESTORE_TASK_EXIST;
            case 150012: return ERESTORE_TASK_NAME_NOT_MATCH;
            case 150013: return ERESTORE_REGION_ID_NOT_MATCH;
            case 150014: return ERESTORE_REGION_META_NOT_FOUND;
            case 150015: return ERESTORE_BACKEND_NOT_SUPPORT;
            case 150016: return ERESTORE_CF_NOT_MATCH;
            case 150017: return ERESTORE_CF_NOT_EXIST;
            case 150018: return ERESTORE_PARSE_FILE_NAME_FAILED;
            case 150019: return EBACKUP_DINGO_STORE_JOB_LIST_EXIST;
            case 150020: return ERESTORE_STORE_NODE_NOT_EXIST;
            case 150021: return ERESTORE_INDEX_NODE_NOT_EXIST;
            case 150022: return ERESTORE_DOCUMENT_NODE_NOT_EXIST;
            default: return null;
        }
    }
}
