package io.dingodb.sdk.service.entity.document;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import io.dingodb.sdk.grpc.serializer.Reader;
import io.dingodb.sdk.grpc.serializer.SizeUtils;
import io.dingodb.sdk.grpc.serializer.Writer;
import io.dingodb.sdk.service.entity.Message;
import io.dingodb.sdk.service.entity.common.DocumentSearchParameter;
import io.dingodb.sdk.service.entity.common.RequestInfo;
import io.dingodb.sdk.service.entity.store.Context;
import io.dingodb.sdk.service.entity.stream.StreamRequestMeta;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.FieldNameConstants;
import lombok.experimental.SuperBuilder;

@Data
@SuperBuilder
@NoArgsConstructor
@FieldNameConstants
public class DocumentSearchAllRequest implements Message, Message.Request, Message.StoreRequest {
    private DocumentSearchParameter parameter;

    private StreamRequestMeta streamMeta;

    private Context context;

    private RequestInfo requestInfo;

    private Object ext$;

    @Override
    public void write(CodedOutputStream out) {
        Writer.write(1, requestInfo, out);
        Writer.write(2, context, out);
        Writer.write(3, parameter, out);
        Writer.write(4, streamMeta, out);
    }

    @Override
    public boolean read(CodedInputStream input) {
        int number = 0;
        boolean hasValue = false;
        while((number = Reader.readNumber(input)) != 0) {
            switch(number) {
                case 1: requestInfo = Reader.readMessage(new RequestInfo(), input); hasValue = hasValue ? hasValue : requestInfo != null; break;
                case 2: context = Reader.readMessage(new Context(), input); hasValue = hasValue ? hasValue : context != null; break;
                case 3: parameter = Reader.readMessage(new DocumentSearchParameter(), input); hasValue = hasValue ? hasValue : parameter != null; break;
                case 4: streamMeta = Reader.readMessage(new StreamRequestMeta(), input); hasValue = hasValue ? hasValue : streamMeta != null; break;
                default: Reader.skip(input);
            }
        }
        return hasValue;
    }

    @Override
    public int sizeOf() {
        int size = 0;
        size += SizeUtils.sizeOf(1, requestInfo);
        size += SizeUtils.sizeOf(2, context);
        size += SizeUtils.sizeOf(3, parameter);
        size += SizeUtils.sizeOf(4, streamMeta);
        return size;
    }
}
