package io.dingodb.sdk.service.entity.document;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import io.dingodb.sdk.grpc.serializer.Reader;
import io.dingodb.sdk.grpc.serializer.SizeUtils;
import io.dingodb.sdk.grpc.serializer.Writer;
import io.dingodb.sdk.service.entity.Message;
import io.dingodb.sdk.service.entity.common.DocumentWithId;
import io.dingodb.sdk.service.entity.common.RequestInfo;
import io.dingodb.sdk.service.entity.store.Context;
import java.util.List;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.FieldNameConstants;
import lombok.experimental.SuperBuilder;

@Data
@SuperBuilder
@NoArgsConstructor
@FieldNameConstants
public class DocumentAddRequest implements Message, Message.Request, Message.StoreRequest {
    private Context context;

    private long ttl;

    private List<DocumentWithId> documents;

    private boolean isUpdate;

    private RequestInfo requestInfo;

    private Object ext$;

    @Override
    public void write(CodedOutputStream out) {
        Writer.write(1, requestInfo, out);
        Writer.write(2, context, out);
        Writer.write(3, documents, (n, v) -> Writer.write(n, v, out));
        Writer.write(4, isUpdate, out);
        Writer.write(5, ttl, out);
    }

    @Override
    public boolean read(CodedInputStream input) {
        int number = 0;
        boolean hasValue = false;
        while((number = Reader.readNumber(input)) != 0) {
            switch(number) {
                case 1: requestInfo = Reader.readMessage(new RequestInfo(), input); hasValue = hasValue ? hasValue : requestInfo != null; break;
                case 2: context = Reader.readMessage(new Context(), input); hasValue = hasValue ? hasValue : context != null; break;
                case 3: documents = Reader.readList(documents, input, in -> Reader.readMessage(new DocumentWithId(), in)); hasValue = true; break;
                case 4: isUpdate = Reader.readBoolean(input); hasValue = true; break;
                case 5: ttl = Reader.readLong(input); hasValue = true; break;
                default: Reader.skip(input);
            }
        }
        return hasValue;
    }

    @Override
    public int sizeOf() {
        int size = 0;
        size += SizeUtils.sizeOf(1, requestInfo);
        size += SizeUtils.sizeOf(2, context);
        size += SizeUtils.sizeOf(3, documents, SizeUtils::sizeOf);
        size += SizeUtils.sizeOf(4, isUpdate);
        size += SizeUtils.sizeOf(5, ttl);
        return size;
    }
}
