package io.dingodb.sdk.service.entity.diskann;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import io.dingodb.sdk.grpc.serializer.Reader;
import io.dingodb.sdk.grpc.serializer.SizeUtils;
import io.dingodb.sdk.grpc.serializer.Writer;
import io.dingodb.sdk.service.entity.Message;
import io.dingodb.sdk.service.entity.common.DiskANNCoreState;
import io.dingodb.sdk.service.entity.common.ResponseInfo;
import io.dingodb.sdk.service.entity.error.Error;
import io.dingodb.sdk.service.entity.index.VectorWithDistanceResult;
import java.util.List;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.FieldNameConstants;
import lombok.experimental.SuperBuilder;

@Data
@SuperBuilder
@NoArgsConstructor
@FieldNameConstants
public class VectorSearchResponse implements Message, Message.Response {
    private Error error;

    private ResponseInfo responseInfo;

    private Error lastError;

    private List<VectorWithDistanceResult> batchResults;

    private DiskANNCoreState state;

    private long ts;

    private Object ext$;

    @Override
    public void write(CodedOutputStream out) {
        Writer.write(1, responseInfo, out);
        Writer.write(2, error, out);
        Writer.write(3, batchResults, (n, v) -> Writer.write(n, v, out));
        Writer.write(4, ts, out);
        Writer.write(5, lastError, out);
        Writer.write(6, state, out);
    }

    @Override
    public boolean read(CodedInputStream input) {
        int number = 0;
        boolean hasValue = false;
        while((number = Reader.readNumber(input)) != 0) {
            switch(number) {
                case 1: responseInfo = Reader.readMessage(new ResponseInfo(), input); hasValue = hasValue ? hasValue : responseInfo != null; break;
                case 2: error = Reader.readMessage(new Error(), input); hasValue = hasValue ? hasValue : error != null; break;
                case 3: batchResults = Reader.readList(batchResults, input, in -> Reader.readMessage(new VectorWithDistanceResult(), in)); hasValue = true; break;
                case 4: ts = Reader.readLong(input); hasValue = true; break;
                case 5: lastError = Reader.readMessage(new Error(), input); hasValue = hasValue ? hasValue : lastError != null; break;
                case 6: state = DiskANNCoreState.forNumber(Reader.readInt(input));hasValue = true; break;
                default: Reader.skip(input);
            }
        }
        return hasValue;
    }

    @Override
    public int sizeOf() {
        int size = 0;
        size += SizeUtils.sizeOf(1, responseInfo);
        size += SizeUtils.sizeOf(2, error);
        size += SizeUtils.sizeOf(3, batchResults, SizeUtils::sizeOf);
        size += SizeUtils.sizeOf(4, ts);
        size += SizeUtils.sizeOf(5, lastError);
        size += SizeUtils.sizeOf(6, state);
        return size;
    }
}
