package io.dingodb.sdk.service.entity.diskann;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import io.dingodb.sdk.grpc.serializer.Reader;
import io.dingodb.sdk.grpc.serializer.SizeUtils;
import io.dingodb.sdk.grpc.serializer.Writer;
import io.dingodb.sdk.service.entity.Message;
import io.dingodb.sdk.service.entity.common.RequestInfo;
import io.dingodb.sdk.service.entity.common.SearchDiskAnnParam;
import io.dingodb.sdk.service.entity.common.Vector;
import java.util.List;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.FieldNameConstants;
import lombok.experimental.SuperBuilder;

@Data
@SuperBuilder
@NoArgsConstructor
@FieldNameConstants
public class VectorSearchRequest implements Message, Message.Request {
    private SearchDiskAnnParam searchParam;

    private RequestInfo requestInfo;

    private List<Vector> vectors;

    private int topN;

    private long vectorIndexId;

    private Object ext$;

    @Override
    public void write(CodedOutputStream out) {
        Writer.write(1, requestInfo, out);
        Writer.write(2, vectorIndexId, out);
        Writer.write(3, topN, out);
        Writer.write(4, searchParam, out);
        Writer.write(5, vectors, (n, v) -> Writer.write(n, v, out));
    }

    @Override
    public boolean read(CodedInputStream input) {
        int number = 0;
        boolean hasValue = false;
        while((number = Reader.readNumber(input)) != 0) {
            switch(number) {
                case 1: requestInfo = Reader.readMessage(new RequestInfo(), input); hasValue = hasValue ? hasValue : requestInfo != null; break;
                case 2: vectorIndexId = Reader.readLong(input); hasValue = true; break;
                case 3: topN = Reader.readInt(input); hasValue = true; break;
                case 4: searchParam = Reader.readMessage(new SearchDiskAnnParam(), input); hasValue = hasValue ? hasValue : searchParam != null; break;
                case 5: vectors = Reader.readList(vectors, input, in -> Reader.readMessage(new Vector(), in)); hasValue = true; break;
                default: Reader.skip(input);
            }
        }
        return hasValue;
    }

    @Override
    public int sizeOf() {
        int size = 0;
        size += SizeUtils.sizeOf(1, requestInfo);
        size += SizeUtils.sizeOf(2, vectorIndexId);
        size += SizeUtils.sizeOf(3, topN);
        size += SizeUtils.sizeOf(4, searchParam);
        size += SizeUtils.sizeOf(5, vectors, SizeUtils::sizeOf);
        return size;
    }
}
