package io.dingodb.sdk.service.entity.diskann;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import io.dingodb.sdk.grpc.serializer.Reader;
import io.dingodb.sdk.grpc.serializer.SizeUtils;
import io.dingodb.sdk.grpc.serializer.Writer;
import io.dingodb.sdk.service.entity.Message;
import io.dingodb.sdk.service.entity.common.RequestInfo;
import io.dingodb.sdk.service.entity.common.Vector;
import io.dingodb.sdk.service.entity.error.Errno;
import java.util.List;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.FieldNameConstants;
import lombok.experimental.SuperBuilder;

@Data
@SuperBuilder
@NoArgsConstructor
@FieldNameConstants
public class VectorPushDataRequest implements Message, Message.Request {
    private Errno error;

    private long alreadySendVectorCount;

    private boolean forceToLoadDataIfExist;

    private List<Long> vectorIds;

    private long tso;

    private long ts;

    private boolean hasMore;

    private RequestInfo requestInfo;

    private List<Vector> vectors;

    private long vectorIndexId;

    private Object ext$;

    @Override
    public void write(CodedOutputStream out) {
        Writer.write(1, requestInfo, out);
        Writer.write(2, vectorIndexId, out);
        Writer.write(3, vectors, (n, v) -> Writer.write(n, v, out));
        Writer.write(4, vectorIds, out, Writer::write, SizeUtils::sizeOf);
        Writer.write(5, hasMore, out);
        Writer.write(6, error, out);
        Writer.write(7, forceToLoadDataIfExist, out);
        Writer.write(8, alreadySendVectorCount, out);
        Writer.write(9, ts, out);
        Writer.write(10, tso, out);
    }

    @Override
    public boolean read(CodedInputStream input) {
        int number = 0;
        boolean hasValue = false;
        while((number = Reader.readNumber(input)) != 0) {
            switch(number) {
                case 1: requestInfo = Reader.readMessage(new RequestInfo(), input); hasValue = hasValue ? hasValue : requestInfo != null; break;
                case 2: vectorIndexId = Reader.readLong(input); hasValue = true; break;
                case 3: vectors = Reader.readList(vectors, input, in -> Reader.readMessage(new Vector(), in)); hasValue = true; break;
                case 4: vectorIds = Reader.readPack(input, Reader::readLong); hasValue = true; break;
                case 5: hasMore = Reader.readBoolean(input); hasValue = true; break;
                case 6: error = Errno.forNumber(Reader.readInt(input));hasValue = true; break;
                case 7: forceToLoadDataIfExist = Reader.readBoolean(input); hasValue = true; break;
                case 8: alreadySendVectorCount = Reader.readLong(input); hasValue = true; break;
                case 9: ts = Reader.readLong(input); hasValue = true; break;
                case 10: tso = Reader.readLong(input); hasValue = true; break;
                default: Reader.skip(input);
            }
        }
        return hasValue;
    }

    @Override
    public int sizeOf() {
        int size = 0;
        size += SizeUtils.sizeOf(1, requestInfo);
        size += SizeUtils.sizeOf(2, vectorIndexId);
        size += SizeUtils.sizeOf(3, vectors, SizeUtils::sizeOf);
        size += SizeUtils.sizeOfPack(4, vectorIds, SizeUtils::sizeOf);
        size += SizeUtils.sizeOf(5, hasMore);
        size += SizeUtils.sizeOf(6, error);
        size += SizeUtils.sizeOf(7, forceToLoadDataIfExist);
        size += SizeUtils.sizeOf(8, alreadySendVectorCount);
        size += SizeUtils.sizeOf(9, ts);
        size += SizeUtils.sizeOf(10, tso);
        return size;
    }
}
