package io.dingodb.sdk.service.entity.debug;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import io.dingodb.sdk.grpc.serializer.Reader;
import io.dingodb.sdk.grpc.serializer.SizeUtils;
import io.dingodb.sdk.grpc.serializer.Writer;
import io.dingodb.sdk.service.entity.Message;
import io.dingodb.sdk.service.entity.store.WriteInfo;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.FieldNameConstants;
import lombok.experimental.SuperBuilder;

@Data
@SuperBuilder
@NoArgsConstructor
@FieldNameConstants
public class Write implements Message {
    private WriteInfo writeInfo;

    private long partitionId;

    private long ts;

    private byte[] key;

    private Object ext$;

    @Override
    public void write(CodedOutputStream out) {
        Writer.write(1, key, out);
        Writer.write(2, ts, out);
        Writer.write(3, writeInfo, out);
        Writer.write(10, partitionId, out);
    }

    @Override
    public boolean read(CodedInputStream input) {
        int number = 0;
        boolean hasValue = false;
        while((number = Reader.readNumber(input)) != 0) {
            switch(number) {
                case 1: key = Reader.readBytes(input); hasValue = true; break;
                case 2: ts = Reader.readLong(input); hasValue = true; break;
                case 3: writeInfo = Reader.readMessage(new WriteInfo(), input); hasValue = hasValue ? hasValue : writeInfo != null; break;
                case 10: partitionId = Reader.readLong(input); hasValue = true; break;
                default: Reader.skip(input);
            }
        }
        return hasValue;
    }

    @Override
    public int sizeOf() {
        int size = 0;
        size += SizeUtils.sizeOf(1, key);
        size += SizeUtils.sizeOf(2, ts);
        size += SizeUtils.sizeOf(3, writeInfo);
        size += SizeUtils.sizeOf(10, partitionId);
        return size;
    }
}
