package io.dingodb.sdk.service.entity.debug;

import io.dingodb.sdk.service.entity.Numeric;

public enum WorkQueueType implements Numeric {
    UNRECOGNIZED(-1),

    WORK_QUEUE_NONE(0),

    WORK_QUEUE_STORE_SERVICE_READ(10),

    WORK_QUEUE_STORE_SERVICE_WRITE(11),

    WORK_QUEUE_INDEX_SERVICE_READ(20),

    WORK_QUEUE_INDEX_SERVICE_WRITE(21),

    WORK_QUEUE_VECTOR_INDEX_BACKGROUND(22);

    public final Integer number;

    private Object ext$;

    private WorkQueueType(Integer number) {
        this.number = number;
    }

    @Override
    public int number() {
        return number;
    }

    public static WorkQueueType forNumber(int number) {
        switch(number) {
            case -1: return UNRECOGNIZED;
            case 0: return WORK_QUEUE_NONE;
            case 10: return WORK_QUEUE_STORE_SERVICE_READ;
            case 11: return WORK_QUEUE_STORE_SERVICE_WRITE;
            case 20: return WORK_QUEUE_INDEX_SERVICE_READ;
            case 21: return WORK_QUEUE_INDEX_SERVICE_WRITE;
            case 22: return WORK_QUEUE_VECTOR_INDEX_BACKGROUND;
            default: return null;
        }
    }
}
