package io.dingodb.sdk.service.entity.debug;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import io.dingodb.sdk.grpc.serializer.Reader;
import io.dingodb.sdk.grpc.serializer.SizeUtils;
import io.dingodb.sdk.grpc.serializer.Writer;
import io.dingodb.sdk.service.entity.Message;
import java.util.List;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.FieldNameConstants;
import lombok.experimental.SuperBuilder;

@Data
@SuperBuilder
@NoArgsConstructor
@FieldNameConstants
public class VectorIndexMetricsEntry implements Message {
    private long keyCount;

    private int dimension;

    private long memorySize;

    private long id;

    private long version;

    private long deletedKeyCount;

    private long applyLogIndex;

    private long snapshotLogIndex;

    private List<RawVectorIndexState> entries;

    private long lastBuildEpochVersion;

    private Object ext$;

    @Override
    public void write(CodedOutputStream out) {
        Writer.write(1, id, out);
        Writer.write(2, version, out);
        Writer.write(3, lastBuildEpochVersion, out);
        Writer.write(10, dimension, out);
        Writer.write(20, applyLogIndex, out);
        Writer.write(30, snapshotLogIndex, out);
        Writer.write(40, keyCount, out);
        Writer.write(50, deletedKeyCount, out);
        Writer.write(60, memorySize, out);
        Writer.write(70, entries, (n, v) -> Writer.write(n, v, out));
    }

    @Override
    public boolean read(CodedInputStream input) {
        int number = 0;
        boolean hasValue = false;
        while((number = Reader.readNumber(input)) != 0) {
            switch(number) {
                case 1: id = Reader.readLong(input); hasValue = true; break;
                case 2: version = Reader.readLong(input); hasValue = true; break;
                case 3: lastBuildEpochVersion = Reader.readLong(input); hasValue = true; break;
                case 10: dimension = Reader.readInt(input); hasValue = true; break;
                case 20: applyLogIndex = Reader.readLong(input); hasValue = true; break;
                case 30: snapshotLogIndex = Reader.readLong(input); hasValue = true; break;
                case 40: keyCount = Reader.readLong(input); hasValue = true; break;
                case 50: deletedKeyCount = Reader.readLong(input); hasValue = true; break;
                case 60: memorySize = Reader.readLong(input); hasValue = true; break;
                case 70: entries = Reader.readList(entries, input, in -> Reader.readMessage(new RawVectorIndexState(), in)); hasValue = true; break;
                default: Reader.skip(input);
            }
        }
        return hasValue;
    }

    @Override
    public int sizeOf() {
        int size = 0;
        size += SizeUtils.sizeOf(1, id);
        size += SizeUtils.sizeOf(2, version);
        size += SizeUtils.sizeOf(3, lastBuildEpochVersion);
        size += SizeUtils.sizeOf(10, dimension);
        size += SizeUtils.sizeOf(20, applyLogIndex);
        size += SizeUtils.sizeOf(30, snapshotLogIndex);
        size += SizeUtils.sizeOf(40, keyCount);
        size += SizeUtils.sizeOf(50, deletedKeyCount);
        size += SizeUtils.sizeOf(60, memorySize);
        size += SizeUtils.sizeOf(70, entries, SizeUtils::sizeOf);
        return size;
    }
}
