package io.dingodb.sdk.service.entity.debug;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import io.dingodb.sdk.grpc.serializer.Reader;
import io.dingodb.sdk.grpc.serializer.SizeUtils;
import io.dingodb.sdk.grpc.serializer.Writer;
import io.dingodb.sdk.service.entity.Message;
import io.dingodb.sdk.service.entity.common.VectorScalardata;
import io.dingodb.sdk.service.entity.common.VectorTableData;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.FieldNameConstants;
import lombok.experimental.SuperBuilder;

@Data
@SuperBuilder
@NoArgsConstructor
@FieldNameConstants
public class Vector implements Message {
    private VectorTableData tableData;

    private VectorScalardata scalarData;

    private ValueFlag flag;

    private long ts;

    private long ttl;

    private long vectorId;

    private byte[] key;

    private io.dingodb.sdk.service.entity.common.Vector vector;

    private Object ext$;

    @Override
    public void write(CodedOutputStream out) {
        Writer.write(1, vectorId, out);
        Writer.write(2, ts, out);
        Writer.write(3, flag, out);
        Writer.write(4, ttl, out);
        Writer.write(10, vector, out);
        Writer.write(11, scalarData, out);
        Writer.write(12, tableData, out);
        Writer.write(20, key, out);
    }

    @Override
    public boolean read(CodedInputStream input) {
        int number = 0;
        boolean hasValue = false;
        while((number = Reader.readNumber(input)) != 0) {
            switch(number) {
                case 1: vectorId = Reader.readLong(input); hasValue = true; break;
                case 2: ts = Reader.readLong(input); hasValue = true; break;
                case 3: flag = ValueFlag.forNumber(Reader.readInt(input));hasValue = true; break;
                case 4: ttl = Reader.readLong(input); hasValue = true; break;
                case 10: vector = Reader.readMessage(new io.dingodb.sdk.service.entity.common.Vector(), input); hasValue = hasValue ? hasValue : vector != null; break;
                case 11: scalarData = Reader.readMessage(new VectorScalardata(), input); hasValue = hasValue ? hasValue : scalarData != null; break;
                case 12: tableData = Reader.readMessage(new VectorTableData(), input); hasValue = hasValue ? hasValue : tableData != null; break;
                case 20: key = Reader.readBytes(input); hasValue = true; break;
                default: Reader.skip(input);
            }
        }
        return hasValue;
    }

    @Override
    public int sizeOf() {
        int size = 0;
        size += SizeUtils.sizeOf(1, vectorId);
        size += SizeUtils.sizeOf(2, ts);
        size += SizeUtils.sizeOf(3, flag);
        size += SizeUtils.sizeOf(4, ttl);
        size += SizeUtils.sizeOf(10, vector);
        size += SizeUtils.sizeOf(11, scalarData);
        size += SizeUtils.sizeOf(12, tableData);
        size += SizeUtils.sizeOf(20, key);
        return size;
    }
}
